/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XLinkTargetSupplier;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;

public class SdPageLinkTargets
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        log.println("creating a test environment");
        XDrawPage the_page = DrawTools.getDrawPage(this.xDrawDoc, 0);
        XLinkTargetSupplier oLTS = UnoRuntime.queryInterface(XLinkTargetSupplier.class, (Object)the_page);
        XNameAccess oObj = oLTS.getLinks();
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        log.println("inserting some Shapes");
        XShapes oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)the_page);
        XShape oShape = SOF.createShape(this.xDrawDoc, 15000, 13500, 5000, 5000, "OLE2");
        oShapes.add(oShape);
        XPropertySet shape_props = UnoRuntime.queryInterface(XPropertySet.class, (Object)oShape);
        log.println("Inserting a Chart");
        try {
            shape_props.setPropertyValue("CLSID", "12DCAE26-281F-416F-a234-c3086127382e");
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't change property", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't change property", e);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't change property", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't change property", e);
        }
        log.println("creating a new environment for LinkTargets object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

