/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XMasterPagesSupplier;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdMasterPagesAccess
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        log.println("creating a test environment");
        log.println("getting MasterPages");
        XMasterPagesSupplier oMPS = UnoRuntime.queryInterface(XMasterPagesSupplier.class, (Object)this.xDrawDoc);
        XDrawPages oMP = oMPS.getMasterPages();
        log.println("insert MasterPages");
        oMP.insertNewByIndex(1);
        oMP.insertNewByIndex(2);
        XDrawPages oObj = oMP;
        log.println("creating a new environment for MasterPagesAccess object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

