/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XMasterPagesSupplier;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;

public class SdMasterPage
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        log.println("getting MasterPages");
        XMasterPagesSupplier oMPS = UnoRuntime.queryInterface(XMasterPagesSupplier.class, (Object)this.xDrawDoc);
        XDrawPages oMPn = oMPS.getMasterPages();
        XIndexAccess oMPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oMPn);
        log.println("getting MasterPage");
        XDrawPage oObj = null;
        try {
            oObj = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oMPi.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get MasterPage by index", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get MasterPage by index", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get MasterPage by index", e);
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        log.println("inserting some Shapes");
        XShapes oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)oObj);
        oShapes.add(SOF.createShape(this.xDrawDoc, 2000, 1500, 1000, 1000, "Line"));
        oShapes.add(SOF.createShape(this.xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse"));
        oShapes.add(SOF.createShape(this.xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle"));
        log.println("creating a new environment for MasterPage object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding DrawPage as mod relation to environment");
        tEnv.addObjRelation("DrawPage", oObj);
        ShapeDsc sDsc = new ShapeDsc(5000, 3500, 7500, 10000, "Rectangle");
        log.println("adding Shape as mod relation to environment");
        tEnv.addObjRelation("Shape", new InstCreator(this.xDrawDoc, sDsc));
        return tEnv;
    }
}

