/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XLayerSupplier;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;

public class SdLayerManager
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        XLayerSupplier oLS = UnoRuntime.queryInterface(XLayerSupplier.class, (Object)this.xDrawDoc);
        XNameAccess oObj = oLS.getLayerManager();
        log.println("creating a new environment for XLayerManager object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        ShapeDsc sDsc = new ShapeDsc(5000, 3500, 7500, 10000, "Rectangle");
        log.println("adding Shape as mod relation to environment");
        tEnv.addObjRelation("Shape", new InstCreator(this.xDrawDoc, sDsc));
        log.println("getting Drawpage");
        XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
        XDrawPages oDPn = oDPS.getDrawPages();
        XIndexAccess oDPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oDPn);
        XDrawPage oDP = null;
        try {
            oDP = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDPi.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        XShapes oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)oDP);
        log.println("adding Shapes as mod relation to environment");
        tEnv.addObjRelation("Shapes", oShapes);
        return tEnv;
    }
}

