/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.drawing.XLayer;
import com.sun.star.drawing.XLayerManager;
import com.sun.star.drawing.XLayerSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class SdLayer
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing xDrawDoc");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XLayer oObj = null;
        XLayerManager oLM = null;
        log.println("creating a test environment");
        log.println("getting LayerManager");
        XLayerSupplier oLS = UnoRuntime.queryInterface(XLayerSupplier.class, (Object)this.xDrawDoc);
        XNameAccess oNA = oLS.getLayerManager();
        oLM = UnoRuntime.queryInterface(XLayerManager.class, (Object)oNA);
        XIndexAccess oIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oLM);
        log.println("getting LayerManager");
        try {
            oObj = (XLayer)AnyConverter.toObject((Type)new Type(XLayer.class), (Object)oIA.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        log.println("creating a new environment for drawpage object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

