/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XModifiable;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class DrawController_HandoutView
extends TestCase {
    static XDesktop the_Desk;
    static XComponent xDrawDoc;
    static XComponent xSecondDrawDoc;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        the_Desk = UnoRuntime.queryInterface(XDesktop.class, DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF()));
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing impress documents");
        DesktopTools.closeDoc(xDrawDoc);
        DesktopTools.closeDoc(xSecondDrawDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)Param.getMSF();
        SOfficeFactory SOF = SOfficeFactory.getFactory(xMSF);
        try {
            log.println("creating two impress documents");
            xSecondDrawDoc = SOF.createImpressDoc(null);
            this.shortWait();
            xDrawDoc = SOF.createImpressDoc(null);
            this.shortWait();
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        log.println("getting Drawpage");
        XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xDrawDoc);
        XDrawPages the_pages = oDPS.getDrawPages();
        for (int i = 1; i < 10; ++i) {
            the_pages.insertNewByIndex(i);
        }
        XIndexAccess oDPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)the_pages);
        XDrawPage oDrawPage = null;
        try {
            oDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDPi.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get DrawPage", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get DrawPage", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get DrawPage", e);
        }
        log.println("inserting some Shapes");
        XShapes oShapes = UnoRuntime.queryInterface(XShapes.class, (Object)oDrawPage);
        XShape shape1 = SOF.createShape(xDrawDoc, 3000, 4500, 15000, 1000, "Ellipse");
        XShape shape2 = SOF.createShape(xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
        XShape shape3 = SOF.createShape(xDrawDoc, 3000, 500, 5000, 1000, "Line");
        oShapes.add(shape1);
        oShapes.add(shape2);
        oShapes.add(shape3);
        this.shortWait();
        log.println("switch to HandoutView...");
        try {
            utils.dispatchURL(xMSF, xDrawDoc, ".uno:HandoutMode");
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed(e.toString()));
        }
        utils.shortWait(500);
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xDrawDoc);
        XController oObj = aModel.getCurrentController();
        log.println("bring first document to front...");
        DesktopTools.bringWindowToFront(aModel);
        XModel aModel2 = UnoRuntime.queryInterface(XModel.class, (Object)xSecondDrawDoc);
        XWindow anotherWindow = UnoRuntime.queryInterface(XWindow.class, (Object)aModel2.getCurrentController());
        log.println("creating a new environment for impress view object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        if (anotherWindow != null) {
            tEnv.addObjRelation("XWindow.AnotherWindow", anotherWindow);
        }
        Object oShapeCol1 = null;
        Object oShapeCol2 = null;
        try {
            oShapeCol1 = xMSF.createInstance("com.sun.star.drawing.ShapeCollection");
            oShapeCol2 = xMSF.createInstance("com.sun.star.drawing.ShapeCollection");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException(Status.failed("Couldn't create instance"));
        }
        XShapes xShapes1 = UnoRuntime.queryInterface(XShapes.class, oShapeCol1);
        XShapes xShapes2 = UnoRuntime.queryInterface(XShapes.class, oShapeCol2);
        xShapes1.add(shape2);
        xShapes1.add(shape3);
        xShapes2.add(shape1);
        this.shortWait();
        tEnv.addObjRelation("Selections", new Object[]{oDrawPage, oShapeCol1, oShapeCol2});
        tEnv.addObjRelation("Comparer", new Comparator(){

            public int compare(Object o1, Object o2) {
                XIndexAccess indAc1 = UnoRuntime.queryInterface(XIndexAccess.class, o1);
                XIndexAccess indAc2 = UnoRuntime.queryInterface(XIndexAccess.class, o2);
                if (indAc1 == null || indAc2 == null) {
                    return -1;
                }
                if (indAc1.getCount() == indAc2.getCount()) {
                    return 0;
                }
                return 1;
            }

            @Override
            public boolean equals(Object obj) {
                return this.compare(this, obj) == 0;
            }
        });
        tEnv.addObjRelation("Pages", the_pages);
        tEnv.addObjRelation("FirstModel", aModel);
        tEnv.addObjRelation("XUserInputInterception.XModel", aModel);
        XFrame the_frame = the_Desk.getCurrentFrame();
        tEnv.addObjRelation("Frame", the_frame);
        aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSecondDrawDoc);
        tEnv.addObjRelation("SecondModel", aModel);
        XController secondController = aModel.getCurrentController();
        tEnv.addObjRelation("SecondController", secondController);
        tEnv.addObjRelation("XDispatchProvider.URL", "slot:27009");
        XDrawPage new_page = the_pages.insertNewByIndex(1);
        tEnv.addObjRelation("DrawPage", new_page);
        log.println("Implementation Name: " + utils.getImplName(oObj));
        XModifiable modify = UnoRuntime.queryInterface(XModifiable.class, (Object)xDrawDoc);
        tEnv.addObjRelation("Modifiable", modify);
        tEnv.addObjRelation("XComponent.DisposeThis", xDrawDoc);
        return tEnv;
    }

    private void shortWait() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

