/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleOutlineView
extends TestCase {
    XModel aModel = null;
    XComponent xImpressDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), this.aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)13);
        oObj = AccessibilityTools.SearchedContext;
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.aModel);
        final XDrawPages oDPn = oDPS.getDrawPages();
        tEnv.addObjRelation("EventMsg", "Inserting a drawpage via API has no effect to the outline view #101050# \r\nTherefore the listener isn't called");
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                oDPn.insertNewByIndex(1);
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing Impress document");
        DesktopTools.closeDoc(this.xImpressDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a impress document");
            this.xImpressDoc = SOF.createImpressDoc(null);
            this.shortWait();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        this.aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xImpressDoc);
        XController oObj = this.aModel.getCurrentController();
        try {
            String aSlotID = "slot:27010";
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)oObj);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = aSlotID;
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            if (xDispatcher != null) {
                xDispatcher.dispatch(aURL, null);
            }
        }
        catch (Exception e) {
            log.println("Couldn't change mode");
        }
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }
}

