/*
 * Decompiled with CFR 0.152.
 */
package mod._sd;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XDrawView;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleDrawDocumentView
extends TestCase {
    XComponent xDrawDoc;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        log.println("getting Drawpage");
        XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xDrawDoc);
        XDrawPages oDPn = oDPS.getDrawPages();
        final XDrawPage fDP2 = oDPn.insertNewByIndex(1);
        XIndexAccess oDPi = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oDPn);
        XDrawPage oDP = null;
        try {
            oDP = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDPi.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        log.println("inserting a Shape");
        XShape oShape = SOF.createShape(this.xDrawDoc, 5000, 3500, 7500, 5000, "Rectangle");
        DrawTools.getShapes(DrawTools.getDrawPage(this.xDrawDoc, 0)).add(oShape);
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xDrawDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)13);
        oObj = AccessibilityTools.SearchedContext;
        log.println("ImplementationName " + utils.getImplName(oObj));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XDrawView xView = UnoRuntime.queryInterface(XDrawView.class, (Object)aModel.getCurrentController());
        final XDrawPage fDP1 = oDP;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                xView.setCurrentPage(fDP2);
                xView.setCurrentPage(fDP1);
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("disposing Draw document");
        DesktopTools.closeDoc(this.xDrawDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a draw document");
            this.xDrawDoc = SOF.createDrawDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }
}

