/*
 * Decompiled with CFR 0.152.
 */
package mod._sch;

import com.sun.star.awt.Rectangle;
import com.sun.star.chart.XChartDataArray;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ChXDiagram
extends TestCase {
    XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a sheetdocument");
            this.xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    closing xSheetDoc ");
        DesktopTools.closeDoc(this.xSheetDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XSpreadsheet oSheet = null;
        XChartDocument xChartDoc = null;
        XDiagram oObj = null;
        System.out.println("Getting spreadsheet");
        XSpreadsheets oSheets = this.xSheetDoc.getSheets();
        XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
        try {
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        }
        log.println("Creating the Header");
        ChXDiagram.insertIntoCell(1, 0, "JAN", oSheet, "");
        ChXDiagram.insertIntoCell(2, 0, "FEB", oSheet, "");
        ChXDiagram.insertIntoCell(3, 0, "MAR", oSheet, "");
        ChXDiagram.insertIntoCell(4, 0, "APR", oSheet, "");
        ChXDiagram.insertIntoCell(5, 0, "MAI", oSheet, "");
        ChXDiagram.insertIntoCell(6, 0, "JUN", oSheet, "");
        ChXDiagram.insertIntoCell(7, 0, "JUL", oSheet, "");
        ChXDiagram.insertIntoCell(8, 0, "AUG", oSheet, "");
        ChXDiagram.insertIntoCell(9, 0, "SEP", oSheet, "");
        ChXDiagram.insertIntoCell(10, 0, "OCT", oSheet, "");
        ChXDiagram.insertIntoCell(11, 0, "NOV", oSheet, "");
        ChXDiagram.insertIntoCell(12, 0, "DEC", oSheet, "");
        ChXDiagram.insertIntoCell(13, 0, "SUM", oSheet, "");
        log.println("Fill the lines");
        ChXDiagram.insertIntoCell(0, 1, "Smith", oSheet, "");
        ChXDiagram.insertIntoCell(1, 1, "42", oSheet, "V");
        ChXDiagram.insertIntoCell(2, 1, "58.9", oSheet, "V");
        ChXDiagram.insertIntoCell(3, 1, "-66.5", oSheet, "V");
        ChXDiagram.insertIntoCell(4, 1, "43.4", oSheet, "V");
        ChXDiagram.insertIntoCell(5, 1, "44.5", oSheet, "V");
        ChXDiagram.insertIntoCell(6, 1, "45.3", oSheet, "V");
        ChXDiagram.insertIntoCell(7, 1, "-67.3", oSheet, "V");
        ChXDiagram.insertIntoCell(8, 1, "30.5", oSheet, "V");
        ChXDiagram.insertIntoCell(9, 1, "23.2", oSheet, "V");
        ChXDiagram.insertIntoCell(10, 1, "-97.3", oSheet, "V");
        ChXDiagram.insertIntoCell(11, 1, "22.4", oSheet, "V");
        ChXDiagram.insertIntoCell(12, 1, "23.5", oSheet, "V");
        ChXDiagram.insertIntoCell(13, 1, "=SUM(B2:M2)", oSheet, "");
        ChXDiagram.insertIntoCell(0, 2, "Jones", oSheet, "");
        ChXDiagram.insertIntoCell(1, 2, "21", oSheet, "V");
        ChXDiagram.insertIntoCell(2, 2, "40.9", oSheet, "V");
        ChXDiagram.insertIntoCell(3, 2, "-57.5", oSheet, "V");
        ChXDiagram.insertIntoCell(4, 2, "-23.4", oSheet, "V");
        ChXDiagram.insertIntoCell(5, 2, "34.5", oSheet, "V");
        ChXDiagram.insertIntoCell(6, 2, "59.3", oSheet, "V");
        ChXDiagram.insertIntoCell(7, 2, "27.3", oSheet, "V");
        ChXDiagram.insertIntoCell(8, 2, "-38.5", oSheet, "V");
        ChXDiagram.insertIntoCell(9, 2, "43.2", oSheet, "V");
        ChXDiagram.insertIntoCell(10, 2, "57.3", oSheet, "V");
        ChXDiagram.insertIntoCell(11, 2, "25.4", oSheet, "V");
        ChXDiagram.insertIntoCell(12, 2, "28.5", oSheet, "V");
        ChXDiagram.insertIntoCell(13, 2, "=SUM(B3:M3)", oSheet, "");
        ChXDiagram.insertIntoCell(0, 3, "Brown", oSheet, "");
        ChXDiagram.insertIntoCell(1, 3, "31.45", oSheet, "V");
        ChXDiagram.insertIntoCell(2, 3, "-20.9", oSheet, "V");
        ChXDiagram.insertIntoCell(3, 3, "-117.5", oSheet, "V");
        ChXDiagram.insertIntoCell(4, 3, "23.4", oSheet, "V");
        ChXDiagram.insertIntoCell(5, 3, "-114.5", oSheet, "V");
        ChXDiagram.insertIntoCell(6, 3, "115.3", oSheet, "V");
        ChXDiagram.insertIntoCell(7, 3, "-171.3", oSheet, "V");
        ChXDiagram.insertIntoCell(8, 3, "89.5", oSheet, "V");
        ChXDiagram.insertIntoCell(9, 3, "41.2", oSheet, "V");
        ChXDiagram.insertIntoCell(10, 3, "71.3", oSheet, "V");
        ChXDiagram.insertIntoCell(11, 3, "25.4", oSheet, "V");
        ChXDiagram.insertIntoCell(12, 3, "38.5", oSheet, "V");
        ChXDiagram.insertIntoCell(13, 3, "=SUM(A4:L4)", oSheet, "");
        Rectangle oRect = new Rectangle(500, 3000, 25000, 11000);
        XCellRange oRange = UnoRuntime.queryInterface(XCellRange.class, (Object)oSheet);
        XCellRange myRange = oRange.getCellRangeByName("A1:N4");
        XCellRangeAddressable oRangeAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)myRange);
        CellRangeAddress myAddr = oRangeAddr.getRangeAddress();
        CellRangeAddress[] oAddr = new CellRangeAddress[]{myAddr};
        XTableChartsSupplier oSupp = UnoRuntime.queryInterface(XTableChartsSupplier.class, (Object)oSheet);
        log.println("Insert Chart");
        XTableCharts oCharts = oSupp.getCharts();
        if (!oCharts.hasByName("ChXDiagram")) {
            oCharts.addNewByName("ChXDiagram", oRect, oAddr, true, true);
        }
        XTableChart oChart = null;
        try {
            oChart = (XTableChart)AnyConverter.toObject((Type)new Type(XTableChart.class), (Object)UnoRuntime.queryInterface(XNameAccess.class, (Object)oCharts).getByName("ChXDiagram"));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }
        XEmbeddedObjectSupplier oEOS = UnoRuntime.queryInterface(XEmbeddedObjectSupplier.class, (Object)oChart);
        XComponent oInt = oEOS.getEmbeddedObject();
        xChartDoc = UnoRuntime.queryInterface(XChartDocument.class, (Object)oInt);
        oObj = xChartDoc.getDiagram();
        log.println("creating a new environment for chartdocument object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding ChartDocument as mod relation to environment");
        tEnv.addObjRelation("CHARTDOC", xChartDoc);
        XChartDataArray da = UnoRuntime.queryInterface(XChartDataArray.class, (Object)xChartDoc.getData());
        int cols = da.getColumnDescriptions().length;
        int rows = da.getRowDescriptions().length;
        tEnv.addObjRelation("ROWAMOUNT", new Integer(rows));
        tEnv.addObjRelation("COLAMOUNT", new Integer(cols));
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        XDiagram stock = SOF.createDiagram(xChartDoc, "StockDiagram");
        tEnv.addObjRelation("STOCK", stock);
        XDiagram bar = SOF.createDiagram(xChartDoc, "BarDiagram");
        tEnv.addObjRelation("BAR", bar);
        XDiagram line = SOF.createDiagram(xChartDoc, "XYDiagram");
        tEnv.addObjRelation("LINE", line);
        XDiagram stack = SOF.createDiagram(xChartDoc, "LineDiagram");
        tEnv.addObjRelation("STACK", stack);
        return tEnv;
    }

    public static void insertIntoCell(int CellX, int CellY, String theValue, XSpreadsheet TT1, String flag) {
        XCell oCell = null;
        try {
            oCell = TT1.getCellByPosition(CellX, CellY);
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println("Could not get Cell");
        }
        if (flag.equals("V")) {
            oCell.setValue(new Float(theValue).floatValue());
        } else {
            oCell.setFormula(theValue);
        }
    }
}

