/*
 * Decompiled with CFR 0.152.
 */
package mod._sch;

import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ChXDataPoint
extends TestCase {
    XChartDocument xChartDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a chartdocument");
            XComponent xComp = SOF.loadDocument(utils.getFullTestURL("TransparencyChart.sxs"));
            this.xChartDoc = UnoRuntime.queryInterface(XChartDocument.class, (Object)xComp);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    closing xChartDoc ");
        DesktopTools.closeDoc(this.xChartDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XPropertySet oObj = null;
        XDiagram oDiagram = null;
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("getting ChXDataRowPoint_Point");
            oDiagram = this.xChartDoc.getDiagram();
            oObj = oDiagram.getDataPointProperties(1, 1);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get ChXDataRowPoint_Point", e);
        }
        log.println("creating a new environment for chartdocument object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XDiagram line = SOF.createDiagram(this.xChartDoc, "XYDiagram");
        tEnv.addObjRelation("LINE", line);
        XDiagram bar = SOF.createDiagram(this.xChartDoc, "BarDiagram");
        tEnv.addObjRelation("BAR", bar);
        log.println("adding ChartDocument as mod relation to environment");
        tEnv.addObjRelation("CHARTDOC", this.xChartDoc);
        return tEnv;
    }
}

