/*
 * Decompiled with CFR 0.152.
 */
package mod._sch;

import com.sun.star.chart.XChartDocument;
import com.sun.star.drawing.XShapeDescriptor;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ChXChartView
extends TestCase {
    XChartDocument xChartDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a chartdocument");
            this.xChartDoc = SOF.createChartDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    closing xChartDoc ");
        DesktopTools.closeDoc(this.xChartDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XController oObj = null;
        XModel oModel = null;
        log.println("getting ChartView");
        oModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xChartDoc);
        oObj = oModel.getCurrentController();
        log.println("creating a new environment for chartdocument object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("Selections", new Object[]{this.xChartDoc.getArea(), this.xChartDoc.getDiagram(), this.xChartDoc.getTitle(), this.xChartDoc.getLegend()});
        tEnv.addObjRelation("Comparer", new Comparator(){

            public int compare(Object o1, Object o2) {
                XShapeDescriptor descr1 = UnoRuntime.queryInterface(XShapeDescriptor.class, o1);
                XShapeDescriptor descr2 = UnoRuntime.queryInterface(XShapeDescriptor.class, o2);
                if (descr1 == null || descr2 == null) {
                    return -1;
                }
                if (descr1.getShapeType().equals(descr2.getShapeType())) {
                    return 0;
                }
                return 1;
            }

            @Override
            public boolean equals(Object obj) {
                return this.compare(this, obj) == 0;
            }
        });
        return tEnv;
    }
}

