/*
 * Decompiled with CFR 0.152.
 */
package mod._sch;

import com.sun.star.chart.XChartData;
import com.sun.star.chart.XChartDocument;
import com.sun.star.frame.XController;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ChXChartDocument
extends TestCase {
    XChartDocument xChartDoc = null;
    XChartDocument doc2 = null;

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    closing xChartDoc ");
        DesktopTools.closeDoc(this.xChartDoc);
        log.println("    closing xChartDoc2 ");
        DesktopTools.closeDoc(this.doc2);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a chartdocument");
            this.xChartDoc = SOF.createChartDoc(null);
            log.println("Waiting before opening second document");
            this.doc2 = SOF.createChartDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
        log.println("getting ChartDocument");
        XChartDocument oObj = this.xChartDoc;
        XController cont1 = this.xChartDoc.getCurrentController();
        XController cont2 = this.doc2.getCurrentController();
        cont1.getFrame().setName("cont1");
        cont2.getFrame().setName("cont2");
        XSelectionSupplier sel = UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)cont1);
        log.println("creating a new environment for chartdocument object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("Adding SelectionSupplier and Shape to select for XModel");
        tEnv.addObjRelation("SELSUPP", sel);
        tEnv.addObjRelation("TOSELECT", this.xChartDoc.getTitle());
        log.println("adding Controller as ObjRelation for XModel");
        tEnv.addObjRelation("CONT2", cont2);
        log.println("adding another Diagram as mod relation to environment");
        tEnv.addObjRelation("DIAGRAM", SOF.createDiagram(this.xChartDoc, "PieDiagram"));
        log.println("adding another ChartData as mod relation to environment");
        XChartData ChartData = this.doc2.getData();
        tEnv.addObjRelation("CHARTDATA", ChartData);
        return tEnv;
    }
}

