/*
 * Decompiled with CFR 0.152.
 */
package mod._sch;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XWindow;
import com.sun.star.chart.XChartDocument;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleDocumentView
extends TestCase {
    XChartDocument xChartDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xChartDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)13);
        oObj = AccessibilityTools.SearchedContext;
        if (oObj == null) {
            log.println("DocumentView hasn't the role 'Document'");
            log.println("trying the role 'Shape'");
            AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)52);
            oObj = AccessibilityTools.SearchedContext;
        }
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XWindow xDocWin = xWindow;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                Rectangle rect = xDocWin.getPosSize();
                xDocWin.setPosSize(100, 100, 100, 100, (short)15);
                xDocWin.setPosSize(rect.X, rect.Y, rect.Width, rect.Height, (short)15);
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    closing xChartDoc ");
        DesktopTools.closeDoc(this.xChartDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("creating a text document");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a chartdocument");
            this.xChartDoc = SOF.createChartDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }
}

