/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XNameAccess;
import com.sun.star.document.XImporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLStylesImporter
extends TestCase {
    static XSpreadsheetDocument xSheetDoc;
    static XComponent comp;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
            comp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        DesktopTools.closeDoc(comp);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Calc.XMLStylesImporter");
            XImporter imp = UnoRuntime.queryInterface(XImporter.class, oInt);
            imp.setTargetDocument(comp);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", comp);
        String impStyleName = "XMLStylesImporter";
        String[][] xml = new String[][]{{"start", "office:document-styles", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:style", "CDATA", "http://openoffice.org/2000/style", "xmlns:fo", "CDATA", "http://www.w3.org/1999/XSL/Format", "xmlns:table", "CDATA", "http://openoffice.org/2000/table"}, {"start", "office:styles"}, {"start", "style:style", "style:name", "CDATA", "XMLStylesImporter", "style:family", "CDATA", "table-cell", "style:parent-style-name", "CDATA", "Default"}, {"start", "style:properties", "fo:width", "CDATA", "12cm", "fo:background-color", "CDATA", "light-grey"}, {"end", "style:properties"}, {"end", "style:style"}, {"end", "office:styles"}, {"end", "office:document-styles"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        XNameAccess styles = null;
        try {
            XStyleFamiliesSupplier sup = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xSheetDoc);
            XNameAccess oStyleFamilies = sup.getStyleFamilies();
            Object family = oStyleFamilies.getByName("CellStyles");
            styles = UnoRuntime.queryInterface(XNameAccess.class, family);
            log.println("Styles before:");
            String[] names = styles.getElementNames();
            for (int i = 0; i < names.length; ++i) {
                log.println("  " + names[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
        final XNameAccess stylesF = styles;
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                logF.println("Styles after:");
                String[] names = stylesF.getElementNames();
                for (int i = 0; i < names.length; ++i) {
                    logF.println("  " + names[i]);
                }
                return stylesF.hasByName("XMLStylesImporter");
            }
        });
        return tEnv;
    }
}

