/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.CalcTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLStylesExporter
extends TestCase {
    static XComponent xSheetDoc;
    protected int counter = 0;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a calc document");
            xSheetDoc = SOF.openDoc("scalc", "_blank");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xCalcDoc ");
        DesktopTools.closeDoc(xSheetDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        FilterChecker filter = new FilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)filter);
        String newName = "NewStyle" + this.counter++;
        filter.addTag(new XMLTools.Tag("office:document-styles"));
        filter.addTag(new XMLTools.Tag("style:style", "style:name", newName));
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Calc.XMLStylesExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(xSheetDoc);
            XStyleFamiliesSupplier styleSup = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xSheetDoc);
            XNameAccess StyleFamilies = styleSup.getStyleFamilies();
            String[] styleFamiliesNames = StyleFamilies.getElementNames();
            XNameContainer StyleFamilyName = (XNameContainer)AnyConverter.toObject((Type)new Type(XNameContainer.class), (Object)StyleFamilies.getByName(styleFamiliesNames[0]));
            Object SC = SOF.createInstance(xSheetDoc, "com.sun.star.style.CellStyle");
            XStyle StyleCell = UnoRuntime.queryInterface(XStyle.class, SC);
            StyleFamilyName.insertByName(newName, StyleCell);
            log.println("fill sheet 1 with contnet...");
            CalcTools.fillCalcSheetWithContent(xSheetDoc, 1, 3, 3, 50, 100);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create environment.", e);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create environment.", e);
        }
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"scalc: StarOffice XML (Calc)"}));
        tEnv.addObjRelation("SourceDocument", xSheetDoc);
        tEnv.addObjRelation("XFilter.Checker", filter);
        return tEnv;
    }

    protected class FilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public FilterChecker(PrintWriter log) {
            super(log, false);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

