/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XImporter;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLSettingsImporter
extends TestCase {
    static XSpreadsheetDocument xSheetDoc;
    static XComponent comp;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
            comp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        DesktopTools.closeDoc(comp);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XPropertySet xPropSet;
        XInterface oObj = null;
        Object oInt = null;
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Calc.XMLSettingsImporter");
            XImporter imp = UnoRuntime.queryInterface(XImporter.class, oInt);
            imp.setTargetDocument(comp);
            XModel xSheetModel = UnoRuntime.queryInterface(XModel.class, (Object)xSheetDoc);
            XController xController = xSheetModel.getCurrentController();
            xPropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xController);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", comp);
        String[][] xml = new String[][]{{"start", "office:document-settings", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:xlink", "CDATA", "http://www.w3.org/1999/xlink", "xmlns:config", "CDATA", "http://openoffice.org/2001/config"}, {"start", "office:settings"}, {"start", "config:config-item-set", "config:name", "CDATA", "view-settings"}, {"start", "config:config-item-map-indexed", "config:name", "CDATA", "Views"}, {"start", "config:config-item-map-entry"}, {"start", "config:config-item", "config:name", "CDATA", "ShowGrid", "config:type", "CDATA", "boolean"}, {"chars", "false"}, {"end", "config:config-item"}, {"start", "config:config-item", "config:name", "CDATA", "ZoomType", "config:type", "CDATA", "short"}, {"chars", "0"}, {"start", "config:config-item", "config:name", "CDATA", "ZoomValue", "config:type", "CDATA", "int"}, {"chars", "124"}, {"end", "config:config-item"}, {"end", "config:config-item"}, {"end", "config:config-item-map-entry"}, {"end", "config:config-item-map-indexed"}, {"end", "config:config-item-set"}, {"end", "office:settings"}, {"end", "office:document-settings"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter logF = log;
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                try {
                    Object gVal = xPropSet.getPropertyValue("ShowGrid");
                    logF.println("ShowGrid = " + gVal);
                    return "false".equals(gVal);
                }
                catch (Exception e) {
                    logF.println("Exception occured while checking filter :");
                    e.printStackTrace(logF);
                    return false;
                }
            }
        });
        return tEnv;
    }
}

