/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XExporter;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.CalcTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLSettingsExporter
extends TestCase {
    static XComponent xSheetDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a calc document");
            xSheetDoc = SOF.openDoc("scalc", "_blank");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xCalcDoc ");
        DesktopTools.closeDoc(xSheetDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        SettingsFilterChecker filter = new SettingsFilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)filter);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Calc.XMLSettingsExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(xSheetDoc);
            XModel xSheetModel = UnoRuntime.queryInterface(XModel.class, (Object)xSheetDoc);
            XController xController = xSheetModel.getCurrentController();
            XPropertySet xPropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xController);
            xPropSet.setPropertyValue("ShowGrid", "false");
            CalcTools.fillCalcSheetWithContent(xSheetDoc, 1, 3, 3, 50, 50);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create environment.", e);
        }
        filter.addTag(new XMLTools.Tag("office:document-settings"));
        filter.addTagEnclosed(new XMLTools.Tag("office:settings"), new XMLTools.Tag("office:document-settings"));
        filter.addCharactersEnclosed("false", new XMLTools.Tag("config:config-item", "config:name", "ShowGrid"));
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"scalc: StarOffice XML (Calc)"}));
        tEnv.addObjRelation("SourceDocument", xSheetDoc);
        tEnv.addObjRelation("XFilter.Checker", filter);
        return tEnv;
    }

    protected class SettingsFilterChecker
    extends XMLTools.XMLChecker
    implements _XFilter.FilterChecker {
        public SettingsFilterChecker(PrintWriter log) {
            super(log, false);
        }

        @Override
        public boolean checkFilter() {
            return this.check();
        }
    }
}

