/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.document.XImporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import ifc.xml.sax._XDocumentHandler;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class XMLImporter
extends TestCase {
    static XComponent xSheetDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            XSpreadsheetDocument xSpreadsheetDoc = SOF.createCalcDoc(null);
            xSheetDoc = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing document ");
        DesktopTools.closeDoc(xSheetDoc);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        Object oInt = null;
        String impValue = "XMLImporter_test";
        log.println("creating a test environment");
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            oInt = xMSF.createInstance("com.sun.star.comp.Calc.XMLImporter");
            XImporter imp = UnoRuntime.queryInterface(XImporter.class, oInt);
            imp.setTargetDocument(xSheetDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        oObj = (XInterface)oInt;
        log.println("creating a new environment for Paragraph object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("TargetDocument", xSheetDoc);
        String[][] xml = new String[][]{{"start", "office:document", "xmlns:office", "CDATA", "http://openoffice.org/2000/office", "xmlns:text", "CDATA", "http://openoffice.org/2000/text", "xmlns:table", "CDATA", "http://openoffice.org/2000/table", "office:class", "CDATA", "spreadsheet"}, {"start", "office:body"}, {"start", "table:table", "table:name", "CDATA", "XMLImporter_test"}, {"end", "table:table"}, {"end", "office:body"}, {"end", "office:document"}};
        tEnv.addObjRelation("XDocumentHandler.XMLData", xml);
        final PrintWriter fLog = log;
        XSpreadsheetDocument xSpreadsheetDoc = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc);
        final XSpreadsheets sheets = xSpreadsheetDoc.getSheets();
        log.println("Sheets before importing :");
        String[] names = sheets.getElementNames();
        for (int i = 0; i < names.length; ++i) {
            log.println("  " + names[i]);
        }
        tEnv.addObjRelation("XDocumentHandler.ImportChecker", new _XDocumentHandler.ImportChecker(){

            @Override
            public boolean checkImport() {
                fLog.println("Sheet names :");
                String[] snames = sheets.getElementNames();
                for (int i = 0; i < snames.length; ++i) {
                    fLog.println("  " + snames[i]);
                }
                return sheets.hasByName("XMLImporter_test");
            }
        });
        return tEnv;
    }
}

