/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.document.XExporter;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.XDocumentHandler;
import ifc.document._XFilter;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.CalcTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.XMLTools;

public class XMLContentExporter
extends TestCase {
    static XComponent xSheetDoc;
    static ContentFilterChecker Filter;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a calc document");
            xSheetDoc = SOF.openDoc("scalc", "_blank");
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xCalcDoc ");
        DesktopTools.closeDoc(xSheetDoc);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XInterface oObj = null;
        String CELL_TEXT = "XMLContentExporter";
        ContentFilterChecker Filter2 = new ContentFilterChecker(log);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)Filter2);
        try {
            oObj = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp.Calc.XMLContentExporter", new Object[]{arg});
            XExporter xEx = UnoRuntime.queryInterface(XExporter.class, (Object)oObj);
            xEx.setSourceDocument(xSheetDoc);
            XSpreadsheetDocument xSpreadsheetDoc = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc);
            XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
            XIndexAccess xSheetsIndexArray = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xSheetsIndexArray.getByIndex(0));
            XCell xCell = xSheet.getCellByPosition(0, 0);
            xCell.setFormula("XMLContentExporter");
            log.println("fill sheet 1 with contnet...");
            CalcTools.fillCalcSheetWithContent(xSheetDoc, 1, 1, 1, 5, 5);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create component.", e);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Can't create environment.", e);
        }
        Filter2.addTag("office:document-content");
        Filter2.addTagEnclosed("office:body", "office:document-content");
        Filter2.addTagEnclosed("office:script", "office:document-content");
        Filter2.addTagEnclosed("table:table", "office:body");
        Filter2.addTagEnclosed("table:table-column", "table:table");
        Filter2.addTagEnclosed("table:table-row", "table:table");
        Filter2.addTagEnclosed("table:table-cell", "table:table-row");
        Filter2.addTagEnclosed("text:p", "table:table-cell");
        Filter2.addCharactersEnclosed("XMLContentExporter", "text:p");
        log.println("creating a new environment");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("MediaDescriptor", XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"scalc: StarOffice XML (Calc)"}));
        tEnv.addObjRelation("SourceDocument", xSheetDoc);
        tEnv.addObjRelation("XFilter.Checker", Filter2);
        return tEnv;
    }

    protected class ContentFilterChecker
    extends XMLTools.XMLTagsChecker
    implements _XFilter.FilterChecker {
        public ContentFilterChecker(PrintWriter log) {
            super(log);
        }

        @Override
        public boolean checkFilter() {
            return this.checkTags();
        }
    }
}

