/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.form.XForm;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XViewPane;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;

public class ScViewPaneObj
extends TestCase {
    private static XSpreadsheetDocument xSpreadsheetDoc;
    private static SOfficeFactory SOF;
    private static XInterface oObj;

    @Override
    public void initialize(TestParameters Param, PrintWriter log) {
        SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("disposing xSpreadsheetDocument");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XModel xm = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XController xc = xm.getCurrentController();
        XIndexAccess xIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xc);
        try {
            oObj = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)xIA.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by index", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("DOCUMENT", UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc));
        tEnv.addObjRelation("XControlAccess.isSheet", Boolean.TRUE);
        XViewPane VP = UnoRuntime.queryInterface(XViewPane.class, (Object)oObj);
        CellRangeAddress dataArea = VP.getVisibleRange();
        tEnv.addObjRelation("DATAAREA", dataArea);
        log.println("adding relation for com.sun.star.view.XFormLayerAccess: XForm");
        XForm myForm = null;
        String kindOfControl = "CommandButton";
        XControlShape aShape = null;
        try {
            log.println("adding contol shape '" + kindOfControl + "'");
            XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
            aShape = FormTools.createControlShape(oComp, 3000, 4500, 15000, 10000, kindOfControl);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create following control shape : '" + kindOfControl + "': ", e);
        }
        try {
            log.println("getting Drawpages");
            XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xSpreadsheetDoc);
            XDrawPages oDP = oDPS.getDrawPages();
            oDP.insertNewByIndex(1);
            oDP.insertNewByIndex(2);
            XDrawPage oDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDP.getByIndex(0));
            if (oDrawPage == null) {
                log.println("ERROR: could not get DrawPage: null");
            }
            oDrawPage.add(aShape);
            log.println("getting XForm");
            XNameContainer xForm = FormTools.getForms(oDrawPage);
            try {
                myForm = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)xForm.getByName("Standard"));
            }
            catch (WrappedTargetException ex) {
                log.println("ERROR: could not XFormm 'Standard': " + ex.toString());
            }
            catch (IllegalArgumentException ex) {
                log.println("ERROR: could not XFormm 'Standard': " + ex.toString());
            }
            catch (NoSuchElementException ex) {
                log.println("ERROR: could not XFormm 'Standard': " + ex.toString());
            }
            if (myForm == null) {
                log.println("ERROR: could not get XForm: null");
            }
            tEnv.addObjRelation("XFormLayerAccess.XForm", myForm);
        }
        catch (IndexOutOfBoundsException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        catch (WrappedTargetException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        return tEnv;
    }
}

