/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XUniqueCellFormatRangesSupplier;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.utils;

public class ScUniqueCellFormatsObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;
    static XSpreadsheet oSheet = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a sheetdocument");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("Getting the first sheet");
        XIndexAccess xIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSheetDoc.getSheets());
        try {
            oSheet = UnoRuntime.queryInterface(XSpreadsheet.class, xIA.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        this.changeColor("A1:A5", 0, 255, 0);
        this.changeColor("A6:B10", 255, 0, 0);
        this.changeColor("B1:B6", 0, 0, 255);
        this.changeColor("B7", 0, 255, 0);
        this.changeColor("B8:B10", 0, 0, 255);
        this.changeColor("C1:C10", 0, 0, 255);
        this.changeColor("D1:D10", 0, 255, 0);
        XUniqueCellFormatRangesSupplier xUCRS = UnoRuntime.queryInterface(XUniqueCellFormatRangesSupplier.class, (Object)oSheet);
        XIndexAccess oObj = xUCRS.getUniqueCellFormatRanges();
        log.println("Implementationname: " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }

    protected void changeColor(String RangeName, int r, int g, int b) {
        XCellRange xRange = oSheet.getCellRangeByName(RangeName);
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xRange);
        Color c = new Color(r, g, b);
        int c2int = 0x1000000 + c.hashCode();
        try {
            xPropertySet.setPropertyValue("CellBackColor", new Integer(c2int));
        }
        catch (UnknownPropertyException e) {
            this.log.println("Couldn't change CellFormat");
        }
        catch (PropertyVetoException e) {
            this.log.println("Couldn't change CellFormat");
        }
        catch (IllegalArgumentException e) {
            this.log.println("Couldn't change CellFormat");
        }
        catch (WrappedTargetException e) {
            this.log.println("Couldn't change CellFormat");
        }
    }
}

