/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScTableSheetsObj
extends TestCase {
    private static XSpreadsheetDocument xSpreadsheetDoc = null;

    @Override
    public void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("disposing xSpreadsheetDocument");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        log.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
        XInterface oObj = UnoRuntime.queryInterface(XInterface.class, (Object)xSpreadsheets);
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("creating instance of the sheet object to use it in tests");
        XSpreadsheet oSecondSheet = null;
        try {
            oSecondSheet = SOfficeFactory.createSpreadsheet(xSpreadsheetDoc);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instances", e);
        }
        tEnv.addObjRelation("SecondInstance", oSecondSheet);
        log.println("adding INSTANCEn as mod relation to environment");
        int THRCNT = 1;
        if ((String)Param.get("THRCNT") != null) {
            THRCNT = Integer.parseInt((String)Param.get("THRCNT"));
        }
        try {
            for (int n = 1; n < THRCNT + 1; ++n) {
                log.println("adding INSTANCE" + n + " as mod relation to environment");
                tEnv.addObjRelation("INSTANCE" + n, SOfficeFactory.createSpreadsheet(xSpreadsheetDoc));
            }
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create instances for object relations", e);
        }
        return tEnv;
    }
}

