/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XScenariosSupplier;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import ifc.util._XSortable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.SOfficeFactory;
import util.ValueComparer;

public class ScTableSheetObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a sheetdocument");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        try {
            XCloseable oCloser = UnoRuntime.queryInterface(XCloseable.class, (Object)xSheetDoc);
            oCloser.close(true);
        }
        catch (CloseVetoException e) {
            log.println("Couldn't close document");
        }
        catch (DisposedException e) {
            log.println("Document already disposed");
        }
        catch (NullPointerException e) {
            log.println("Couldn't get XCloseable");
        }
        try {
            log.println("Sleeping 500 Millis");
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.println("... Done");
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        log.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSheetDoc.getSheets();
        log.println("getting a sheet");
        XSpreadsheet oSheet = null;
        XIndexAccess oIndexAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        log.println("filling some cells");
        try {
            oSheet.getCellByPosition(5, 5).setValue(15.0);
            oSheet.getCellByPosition(1, 4).setValue(10.0);
            oSheet.getCellByPosition(2, 0).setValue(-5.15);
            oSheet.getCellByPosition(8, 8).setFormula("= B5 + C1");
            oSheet.getCellByPosition(6, 6).setValue(3.0);
            oSheet.getCellByPosition(7, 6).setValue(3.0);
            oSheet.getCellByPosition(8, 6).setFormula("= SUM(G7:H7)");
            oSheet.getCellByPosition(9, 6).setFormula("= G7*I7");
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Exception occurred while filling cells", e);
        }
        oObj = UnoRuntime.queryInterface(XInterface.class, (Object)oSheet);
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XCELLSERIES_FILLAUTO", new Boolean(false));
        tEnv.addObjRelation("CellRangeAddress", new CellRangeAddress(0, 6, 6, 8, 8));
        tEnv.addObjRelation("CellRangeSubAddress", new CellRangeAddress(0, 6, 6, 7, 8));
        tEnv.addObjRelation("XSheetAuditing.CellAddress", new CellAddress(0, 8, 6));
        tEnv.addObjRelation("XSheetAuditing.PrecedentCellAddress", new CellAddress(0, 7, 6));
        tEnv.addObjRelation("XSheetAuditing.DependentCellAddress", new CellAddress(0, 9, 6));
        tEnv.addObjRelation("XSheetLinkable.LinkSheet", "ScSheetLinksObj.sdc");
        XScenariosSupplier scene = UnoRuntime.queryInterface(XScenariosSupplier.class, (Object)tEnv.getTestObject());
        scene.getScenarios().addNewByName("Scenario", new CellRangeAddress[]{new CellRangeAddress(0, 0, 0, 10, 10)}, "Comment");
        XSpreadsheet sSheet = null;
        try {
            sSheet = UnoRuntime.queryInterface(XSpreadsheet.class, xSpreadsheets.getByName("Scenario"));
        }
        catch (NoSuchElementException e) {
            log.println("Couldn't get Scenario");
        }
        catch (WrappedTargetException e) {
            log.println("Couldn't get Scenario");
        }
        tEnv.addObjRelation("ScenarioSheet", sSheet);
        log.println("adding ObjRelation 'noArray' to avoid the test 'XArrayFormulaRange'");
        tEnv.addObjRelation("noArray", "ScTableSheetObj");
        XPropertySet PropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        tEnv.addObjRelation("PropSet", PropSet);
        tEnv.addObjRelation("SHEET", oSheet);
        String[] expectedResults = new String[]{"Sheet1.B5;Sheet1.C1", "Sheet1.B5;Sheet1.C1;Sheet1.F6", "Sheet1.A1 ... Sheet1.B1 ... Sheet1.B6 ... Sheet1.C2 ... Sheet1.D1 ... Sheet1.F1 ... Sheet1.F7 ... Sheet1.G1", "Sheet1.I7:J7;Sheet1.I9", "Sheet1.D4", "Sheet1.A5;Sheet1.C1", "Sheet1.A2"};
        tEnv.addObjRelation("XCellRangesQuery.EXPECTEDRESULTS", expectedResults);
        try {
            tEnv.addObjRelation("MAKEENTRYINCELL", oSheet.getCellByPosition(15, 15));
            tEnv.addObjRelation("RANGEINDICES", new int[]{0, 0});
            tEnv.addObjRelation("EXPECTEDDEPENDENTVALUES", new int[]{0, 255, 0, 65535});
            tEnv.addObjRelation("EXPECTEDPRECEDENTVALUES", new int[]{0, 255, 0, 65535});
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Cannot add the necessary object relation for XFormulaQuery test.");
        }
        try {
            tEnv.addObjRelation("XSearchable.MAKEENTRYINCELL", new XCell[]{oSheet.getCellByPosition(15, 15), oSheet.getCellByPosition(15, 16)});
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            log.println("Cannot make required object relation 'XSearchable.MAKEENTRYINCELL'.");
        }
        final PrintWriter finalLog = log;
        final XSpreadsheet oTable = oSheet;
        tEnv.addObjRelation("SORTCHECKER", new _XSortable.XSortChecker(){
            PrintWriter out;
            {
                this.out = finalLog;
            }

            @Override
            public void setPrintWriter(PrintWriter log) {
                this.out = log;
            }

            @Override
            public void prepareToSort() {
                try {
                    oTable.getCellByPosition(0, 0).setValue(4.0);
                    oTable.getCellByPosition(0, 1).setFormula("b");
                    oTable.getCellByPosition(0, 2).setValue(3.0);
                    oTable.getCellByPosition(0, 3).setValue(23.0);
                }
                catch (IndexOutOfBoundsException e) {
                    this.out.println("Exception while checking sort");
                }
            }

            @Override
            public boolean checkSort(boolean isSortNumbering, boolean isSortAscending) {
                this.out.println("Sort checking...");
                boolean res = false;
                String[] value = new String[4];
                for (int i = 0; i < 4; ++i) {
                    try {
                        XCell cell = oTable.getCellByPosition(0, i);
                        value[i] = cell.getFormula();
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.out.println("Exception while checking sort");
                    }
                }
                if (isSortNumbering) {
                    String[] vals;
                    if (isSortAscending) {
                        this.out.println("Sorting ascending");
                        String[] rightVal = new String[]{"3", "4", "23", "b"};
                        vals = new String[]{value[0], value[1], value[2], value[3]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        this.out.println("Expected 3, 4, 23, b");
                        this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                    } else {
                        String[] rightVal = new String[]{"b", "23", "4", "3"};
                        vals = new String[]{value[0], value[1], value[2], value[3]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        this.out.println("Expected b, 23, 4, 3");
                        this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                    }
                } else if (isSortAscending) {
                    String[] rightVal = new String[]{"3", "4", "23", "b"};
                    res = ValueComparer.equalValue(value, rightVal);
                    this.out.println("Expected 3, 4, 23, b");
                    this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                } else {
                    String[] rightVal = new String[]{"b", "23", "4", "3"};
                    res = ValueComparer.equalValue(value, rightVal);
                    this.out.println("Expected b, 23, 4, 3");
                    this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                }
                if (res) {
                    this.out.println("Sorted correctly");
                } else {
                    this.out.println("Sorted uncorrectly");
                }
                return res;
            }
        });
        return tEnv;
    }
}

