/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.form.XForm;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import java.util.Comparator;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.FormTools;
import util.SOfficeFactory;
import util.ValueComparer;

public class ScTabViewObj
extends TestCase {
    public static XSpreadsheetDocument xSpreadsheetDoc;
    public static XSpreadsheetDocument xSpreadsheetDoc2;

    @Override
    public void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating two spreadsheet documents");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            xSpreadsheetDoc2 = SOF.createCalcDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
        XComponent oComp2 = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc2);
        DesktopTools.closeDoc(oComp2);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XDrawPage oDrawPage = null;
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XModel aSecondModel = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc2);
        XController oObj = aModel.getCurrentController();
        log.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
        log.println("getting a sheet");
        XSpreadsheet oSheet = null;
        XIndexAccess oIndexAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexAccess.getByIndex(1));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XDispatchProvider.URL", ".uno:Copy");
        log.println("adding 'Sheet' as ObjRelation");
        tEnv.addObjRelation("Sheet", oSheet);
        tEnv.addObjRelation("Frame", aModel.getCurrentController().getFrame());
        tEnv.addObjRelation("SecondModel", aSecondModel);
        tEnv.addObjRelation("FirstModel", aModel);
        tEnv.addObjRelation("DOCUMENT", UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc));
        tEnv.addObjRelation("XControlAccess.isSheet", Boolean.TRUE);
        XCell cell_1 = null;
        XCell cell_2 = null;
        XCellRange cellRange = null;
        try {
            cellRange = oSheet.getCellRangeByPosition(0, 0, 3, 3);
            cell_1 = oSheet.getCellByPosition(5, 5);
            cell_2 = oSheet.getCellByPosition(7, 7);
            cell_2.setValue(17.5);
            cell_1.setValue(5.5);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get some cell", e);
        }
        Object[] selections = new Object[]{oSheet, cellRange, cell_1, cell_2};
        tEnv.addObjRelation("Selections", selections);
        tEnv.addObjRelation("Comparer", new Comparator(){

            public int compare(Object o1, Object o2) {
                CellRangeAddress range2;
                XCellRangeAddressable adr1 = UnoRuntime.queryInterface(XCellRangeAddressable.class, o1);
                XCellRangeAddressable adr2 = UnoRuntime.queryInterface(XCellRangeAddressable.class, o2);
                if (adr1 == null || adr2 == null) {
                    return -1;
                }
                CellRangeAddress range1 = adr1.getRangeAddress();
                return ValueComparer.equalValue(range1, range2 = adr2.getRangeAddress()) ? 0 : 1;
            }

            @Override
            public boolean equals(Object obj) {
                return this.compare(this, obj) == 0;
            }
        });
        tEnv.addObjRelation("XUserInputInterception.XModel", aModel);
        XForm myForm = null;
        String kindOfControl = "CommandButton";
        XControlShape aShape = null;
        try {
            log.println("adding contol shape '" + kindOfControl + "'");
            XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
            aShape = FormTools.createControlShape(oComp, 3000, 4500, 15000, 10000, kindOfControl);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create following control shape : '" + kindOfControl + "': ", e);
        }
        log.println("adding relation for com.sun.star.view.XFormLayerAccess: XForm");
        try {
            log.println("getting Drawpages");
            XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xSpreadsheetDoc);
            XDrawPages oDP = oDPS.getDrawPages();
            oDP.insertNewByIndex(1);
            oDP.insertNewByIndex(2);
            oDrawPage = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDP.getByIndex(0));
            if (oDrawPage == null) {
                log.println("ERROR: could not get DrawPage: null");
            }
            oDrawPage.add(aShape);
            log.println("getting XForm");
            XNameContainer xForm = FormTools.getForms(oDrawPage);
            try {
                myForm = (XForm)AnyConverter.toObject((Type)new Type(XForm.class), (Object)xForm.getByName("Standard"));
            }
            catch (WrappedTargetException ex) {
                log.println("ERROR: could not XFormm 'Standard': " + ex.toString());
            }
            catch (IllegalArgumentException ex) {
                log.println("ERROR: could not XFormm 'Standard': " + ex.toString());
            }
            catch (NoSuchElementException ex) {
                log.println("ERROR: could not XFormm 'Standard': " + ex.toString());
            }
            if (myForm == null) {
                log.println("ERROR: could not get XForm: null");
            }
            tEnv.addObjRelation("XFormLayerAccess.XForm", myForm);
        }
        catch (IndexOutOfBoundsException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        catch (WrappedTargetException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        catch (IllegalArgumentException ex) {
            log.println("ERROR: could not add ObjectRelation 'XFormLayerAccess.XForm': " + ex.toString());
        }
        return tEnv;
    }
}

