/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScStyleFamilyObj
extends TestCase {
    static XSpreadsheetDocument xSpreadsheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        log.println("creating a test environment");
        XNameAccess oStyleFamilyNameAccess = null;
        log.println("getting style");
        XStyleFamiliesSupplier oStyleFamiliesSupplier = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xSpreadsheetDoc);
        XNameAccess oStyleFamilies = oStyleFamiliesSupplier.getStyleFamilies();
        XIndexAccess oStyleFamiliesIndexAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oStyleFamilies);
        try {
            oStyleFamilyNameAccess = (XNameAccess)AnyConverter.toObject((Type)new Type(XNameAccess.class), (Object)oStyleFamiliesIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Exception occured while getting StyleFamily", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Exception occured while getting StyleFamily", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Exception occured while getting StyleFamily", e);
        }
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        XComponent xComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        XInterface oInstance = (XInterface)SOF.createInstance(xComp, "com.sun.star.style.CellStyle");
        XNameContainer oContainer = UnoRuntime.queryInterface(XNameContainer.class, (Object)oStyleFamilyNameAccess);
        try {
            oContainer.insertByName("ScStyleFamilyObj", oInstance);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert new style family", e);
        }
        catch (ElementExistException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert new style family", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't insert new style family", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oStyleFamilyNameAccess);
        oInstance = (XInterface)SOF.createInstance(xComp, "com.sun.star.style.CellStyle");
        tEnv.addObjRelation("SecondInstance", oInstance);
        int THRCNT = 1;
        if ((String)tParam.get("THRCNT") != null) {
            THRCNT = Integer.parseInt((String)tParam.get("THRCNT"));
        }
        log.println("adding XNameReplaceINDEX as mod relation to environment");
        tEnv.addObjRelation("XNameReplaceINDEX", new Integer(2 * THRCNT).toString());
        log.println("adding INSTANCEn as mod relation to environment");
        for (int n = 1; n < 2 * (THRCNT + 1); ++n) {
            log.println("adding INSTANCE" + n + " as mod relation to environment");
            tEnv.addObjRelation("INSTANCE" + n, SOF.createInstance(xComp, "com.sun.star.style.CellStyle"));
        }
        log.println("adding NAMEREPLACE as mod relation to environment");
        String cName = "ScStyleFamilyObj";
        tEnv.addObjRelation("NAMEREPLACE", cName);
        return tEnv;
    }
}

