/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.SOfficeFactory;
import util.utils;

public class ScShapeObj
extends TestCase {
    static XComponent xSheetDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a sheetdoc");
            xSheetDoc = UnoRuntime.queryInterface(XComponent.class, (Object)SOF.createCalcDoc(null));
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        DesktopTools.closeDoc(xSheetDoc);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XShape oObj = null;
        XShape oShape = null;
        log.println("creating a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        oShape = SOF.createShape(xSheetDoc, 5000, 3500, 7500, 5000, "Rectangle");
        DrawTools.getShapes(DrawTools.getDrawPage(xSheetDoc, 0)).add(oShape);
        oObj = oShape;
        for (int i = 0; i < 10; ++i) {
            DrawTools.getShapes(DrawTools.getDrawPage(xSheetDoc, 0)).add(SOF.createShape(xSheetDoc, 5000, 3500, 7510 + 10 * i, 5010 + 10 * i, "Rectangle"));
        }
        TestEnvironment tEnv = new TestEnvironment(oShape);
        log.println("Implementation name: " + utils.getImplName(oObj));
        tEnv.addObjRelation("DOCUMENT", xSheetDoc);
        return tEnv;
    }
}

