/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XScenarios;
import com.sun.star.sheet.XScenariosSupplier;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScScenariosObj
extends TestCase {
    public static XSpreadsheetDocument xSpreadsheetDoc;

    @Override
    public void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        log.println("getting sheets");
        XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
        log.println("getting a sheet");
        XSpreadsheet oSheet = null;
        XIndexAccess oIndexAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexAccess.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        log.println("filling some cells");
        try {
            oSheet.getCellByPosition(5, 5).setValue(15.0);
            oSheet.getCellByPosition(1, 4).setValue(10.0);
            oSheet.getCellByPosition(2, 0).setValue(-5.15);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't fill some cell", e);
        }
        XScenariosSupplier xSupp = UnoRuntime.queryInterface(XScenariosSupplier.class, (Object)oSheet);
        XCellRange oRange = UnoRuntime.queryInterface(XCellRange.class, (Object)oSheet);
        XCellRange myRange = oRange.getCellRangeByName("A1:N4");
        XCellRangeAddressable oRangeAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)myRange);
        CellRangeAddress myAddr = oRangeAddr.getRangeAddress();
        CellRangeAddress[] oAddr = new CellRangeAddress[]{myAddr};
        xSupp.getScenarios().addNewByName("ScScenarios", oAddr, "Range");
        XScenarios oObj = xSupp.getScenarios();
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("adding ObjectRelation for XScenarios");
        tEnv.addObjRelation("ADDR", oAddr);
        return tEnv;
    }
}

