/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;
import ifc.view._XPrintJobBroadcaster;
import java.io.File;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScModelObj
extends TestCase {
    public static XSpreadsheetDocument xSpreadsheetDoc;
    public static XSpreadsheetDocument xSecondsheetDoc;

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
        oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSecondsheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XComponent oComp;
        log.println("craeting a test environment");
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        if (xSpreadsheetDoc != null) {
            oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
            DesktopTools.closeDoc(oComp);
        }
        if (xSecondsheetDoc != null) {
            oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSecondsheetDoc);
            DesktopTools.closeDoc(oComp);
        }
        try {
            log.println("creating two spreadsheet documents");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
            xSecondsheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
        XModel model1 = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XModel model2 = UnoRuntime.queryInterface(XModel.class, (Object)xSecondsheetDoc);
        XModel oObj = model1;
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XController cont1 = model1.getCurrentController();
        XController cont2 = model2.getCurrentController();
        cont1.getFrame().setName("cont1");
        cont2.getFrame().setName("cont2");
        XSelectionSupplier sel = UnoRuntime.queryInterface(XSelectionSupplier.class, (Object)cont1);
        XCell toSel = null;
        XCell[] xCalculatableCells = null;
        try {
            log.println("Getting spreadsheet");
            XSpreadsheets oSheets = xSpreadsheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            XSpreadsheet oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
            log.println("Getting a cell from sheet");
            toSel = oSheet.getCellByPosition(2, 3);
            oSheet.getCellByPosition(4, 5).setValue(15.0);
            oSheet.getCellByPosition(5, 5).setValue(10.0);
            oSheet.getCellByPosition(6, 5).setFormula("= E6 * F6");
            xCalculatableCells = new XCell[]{oSheet.getCellByPosition(4, 5), oSheet.getCellByPosition(5, 5), oSheet.getCellByPosition(6, 5)};
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        log.println("Adding SelectionSupplier and Shape to select for XModel");
        tEnv.addObjRelation("SELSUPP", sel);
        tEnv.addObjRelation("TOSELECT", toSel);
        log.println("Adding cells for XCalculatable");
        tEnv.addObjRelation("XCalculatable.Cells", xCalculatableCells);
        log.println("adding Controller as ObjRelation for XModel");
        tEnv.addObjRelation("CONT2", cont2);
        String fileName = utils.getOfficeTempDirSys((XMultiServiceFactory)Param.getMSF()) + "printfile.prt";
        File f = new File(fileName);
        if (f.exists()) {
            f.delete();
        }
        _XPrintJobBroadcaster.MyPrintJobListener listener = new _XPrintJobBroadcaster.MyPrintJobListener(oObj, fileName);
        tEnv.addObjRelation("XPrintJobBroadcaster.XPrintJobListener", listener);
        return tEnv;
    }
}

