/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XImportable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScImportDescriptorBase
extends TestCase {
    XSpreadsheetDocument xSpreadsheetDoc;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            this.xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    public TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) throws StatusException {
        XInterface oObj = null;
        XImportable xIMP = null;
        log.println("creating a test environment");
        log.println("getting sheets");
        XSpreadsheets xSpreadsheets = this.xSpreadsheetDoc.getSheets();
        if (xSpreadsheets == null) {
            log.println("FAILED");
        } else {
            log.println("OK");
        }
        log.println("getting a sheet");
        XIndexAccess oIndexAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            oObj = UnoRuntime.queryInterface(XInterface.class, oIndexAccess.getByIndex(0));
        }
        catch (Exception e) {
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        xIMP = UnoRuntime.queryInterface(XImportable.class, (Object)oObj);
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("xIMP", xIMP);
        return tEnv;
    }
}

