/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.DrawTools;
import util.InstCreator;
import util.SOfficeFactory;
import util.ShapeDsc;
import util.utils;

public class ScDrawPageObj
extends TestCase {
    static XSpreadsheetDocument xDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a sheetdocument");
            xDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent xComp = UnoRuntime.queryInterface(XComponent.class, (Object)xDoc);
        DesktopTools.closeDoc(xComp);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XDrawPage oObj = null;
        XShape oShape = null;
        XDrawPages oDP = null;
        XComponent xComp = UnoRuntime.queryInterface(XComponent.class, (Object)xDoc);
        log.println("creating a test environment");
        try {
            log.println("getting Drawpages");
            XDrawPagesSupplier oDPS = UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xDoc);
            oDP = oDPS.getDrawPages();
            oDP.insertNewByIndex(1);
            oDP.insertNewByIndex(2);
            oObj = (XDrawPage)AnyConverter.toObject((Type)new Type(XDrawPage.class), (Object)oDP.getByIndex(0));
            SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
            oShape = SOF.createShape(xComp, 5000, 3500, 7500, 5000, "Rectangle");
            DrawTools.getShapes(oObj).add(oShape);
            XShape oShape1 = SOF.createShape(xComp, 5000, 5500, 5000, 5000, "Rectangle");
            DrawTools.getShapes(oObj).add(oShape1);
        }
        catch (WrappedTargetException e) {
            log.println("Couldn't create insance");
            e.printStackTrace(log);
            throw new StatusException("Can't create enviroment", e);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Couldn't create insance");
            e.printStackTrace(log);
            throw new StatusException("Can't create enviroment", e);
        }
        catch (IllegalArgumentException e) {
            log.println("Couldn't create insance");
            e.printStackTrace(log);
            throw new StatusException("Can't create enviroment", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        ShapeDsc sDsc = new ShapeDsc(5000, 3500, 7500, 10000, "Line");
        tEnv.addObjRelation("Shape", new InstCreator(xDoc, sDsc));
        log.println("ImplementationName: " + utils.getImplName(oObj));
        tEnv.addObjRelation("DrawPage", oObj);
        return tEnv;
    }
}

