/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.DataImportMode;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XCellRangeReferrer;
import com.sun.star.sheet.XDatabaseRanges;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XImportable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScDatabaseRangeObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        log.println("Creating a test environment");
        log.println("Getting test object ");
        XPropertySet docProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)xSheetDoc);
        XSpreadsheets sheets = xSheetDoc.getSheets();
        String[] names = sheets.getElementNames();
        XDatabaseRanges dbRanges = null;
        XImportable xImp = null;
        try {
            Object sheet = sheets.getByName(names[0]);
            xImp = UnoRuntime.queryInterface(XImportable.class, sheet);
            dbRanges = (XDatabaseRanges)AnyConverter.toObject((Type)new Type(XDatabaseRanges.class), (Object)docProps.getPropertyValue("DatabaseRanges"));
            this._doImport(xImp);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a property", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a property", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get a property", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        if (dbRanges.hasByName("dbRange")) {
            dbRanges.removeByName("dbRange");
        }
        CellRangeAddress aRange = null;
        XNameAccess dbrNA = UnoRuntime.queryInterface(XNameAccess.class, (Object)dbRanges);
        XNamed xNamed = null;
        try {
            String[] dbNames = dbrNA.getElementNames();
            xNamed = UnoRuntime.queryInterface(XNamed.class, dbrNA.getByName(dbNames[0]));
            xNamed.setName("dbRange");
            XCellRangeReferrer aReferrer = UnoRuntime.queryInterface(XCellRangeReferrer.class, dbrNA.getByName("dbRange"));
            XCellRangeAddressable aRangeA = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)aReferrer.getReferredCells());
            aRange = aRangeA.getRangeAddress();
            oObj = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)dbrNA.getByName("dbRange"));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("DATAAREA", aRange);
        XCellRange xCellRange = null;
        try {
            Object sheet = sheets.getByName(names[0]);
            xCellRange = UnoRuntime.queryInterface(XCellRange.class, sheet);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting of first spreadsheet from spreadsheet document", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting of first spreadsheet from spreadsheet document", e);
        }
        tEnv.addObjRelation("XCELLRANGE", xCellRange);
        return tEnv;
    }

    public void _doImport(XImportable imp) {
        PropertyValue[] descriptor = imp.createImportDescriptor(false);
        this.log.print("Setting the ImportDescriptor (Bibliograpy, SQL, select Identifier from biblio) -- ");
        descriptor[0].Value = "Bibliography";
        descriptor[1].Value = DataImportMode.SQL;
        descriptor[2].Value = "select Identifier from biblio";
        this.log.println("done");
        this.log.print("Importing data (Bibliograpy, Table, biblio) -- ");
        imp.doImport(descriptor);
        this.log.println("done");
    }
}

