/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.DataPilotFieldGroupInfo;
import com.sun.star.sheet.DataPilotFieldOrientation;
import com.sun.star.sheet.GeneralFunction;
import com.sun.star.sheet.XDataPilotDescriptor;
import com.sun.star.sheet.XDataPilotFieldGrouping;
import com.sun.star.sheet.XDataPilotTables;
import com.sun.star.sheet.XDataPilotTablesSupplier;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScDataPilotFieldGroupObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;
    private int mMaxFieldIndex = 6;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        XInterface datapilotfield = null;
        XNameAccess groups = null;
        log.println("Creating a test environment");
        CellRangeAddress sCellRangeAdress = new CellRangeAddress();
        sCellRangeAdress.Sheet = 0;
        sCellRangeAdress.StartColumn = 1;
        sCellRangeAdress.StartRow = 0;
        sCellRangeAdress.EndColumn = this.mMaxFieldIndex - 1;
        sCellRangeAdress.EndRow = this.mMaxFieldIndex - 1;
        CellAddress sCellAdress = new CellAddress();
        sCellAdress.Sheet = 0;
        sCellAdress.Column = 7;
        sCellAdress.Row = 8;
        log.println("Getting a sheet");
        XSpreadsheets xSpreadsheets = xSheetDoc.getSheets();
        XSpreadsheet oSheet = null;
        XSpreadsheet oSheet2 = null;
        XIndexAccess oIndexAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
        try {
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexAccess.getByIndex(0));
            oSheet2 = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexAccess.getByIndex(1));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't get a spreadsheet", e);
        }
        try {
            int i;
            log.println("Filling a table");
            for (i = 1; i < this.mMaxFieldIndex; ++i) {
                oSheet.getCellByPosition(i, 0).setFormula("Col" + i);
                oSheet.getCellByPosition(0, i).setFormula("Row" + i);
                oSheet2.getCellByPosition(i, 0).setFormula("Col" + i);
                oSheet2.getCellByPosition(0, i).setFormula("Row" + i);
            }
            for (i = 1; i < this.mMaxFieldIndex; ++i) {
                for (int j = 1; j < this.mMaxFieldIndex; ++j) {
                    oSheet.getCellByPosition(i, j).setValue(i * (j + 1));
                    oSheet2.getCellByPosition(i, j).setValue(i * (j + 2));
                }
            }
            oSheet.getCellByPosition(1, 1).setFormula("aName");
            oSheet.getCellByPosition(1, 2).setFormula("otherName");
            oSheet.getCellByPosition(1, 3).setFormula("una");
            oSheet.getCellByPosition(1, 4).setFormula("otherName");
            oSheet.getCellByPosition(1, 5).setFormula("somethingelse");
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't fill some cells", e);
        }
        XCell oChangeCell = null;
        XCell oCheckCell = null;
        Integer aChangeValue = null;
        try {
            oChangeCell = oSheet.getCellByPosition(1, 5);
            int x = sCellAdress.Column;
            int y = sCellAdress.Row + 3;
            oCheckCell = oSheet.getCellByPosition(x, y);
            aChangeValue = new Integer(27);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't get cells for changeing.", e);
        }
        log.println("Getting test objects");
        XDataPilotTablesSupplier DPTS = UnoRuntime.queryInterface(XDataPilotTablesSupplier.class, (Object)oSheet);
        XDataPilotTables DPT = DPTS.getDataPilotTables();
        XDataPilotDescriptor DPDsc = DPT.createDataPilotDescriptor();
        DPDsc.setSourceRange(sCellRangeAdress);
        XPropertySet fieldPropSet = null;
        try {
            Object oDataPilotField = DPDsc.getDataPilotFields().getByIndex(0);
            fieldPropSet = UnoRuntime.queryInterface(XPropertySet.class, oDataPilotField);
            fieldPropSet.setPropertyValue("Orientation", DataPilotFieldOrientation.ROW);
            oDataPilotField = DPDsc.getDataPilotFields().getByIndex(1);
            fieldPropSet = UnoRuntime.queryInterface(XPropertySet.class, oDataPilotField);
            fieldPropSet.setPropertyValue("Function", GeneralFunction.SUM);
            fieldPropSet.setPropertyValue("Orientation", DataPilotFieldOrientation.DATA);
            oDataPilotField = DPDsc.getDataPilotFields().getByIndex(2);
            fieldPropSet = UnoRuntime.queryInterface(XPropertySet.class, oDataPilotField);
            fieldPropSet.setPropertyValue("Orientation", DataPilotFieldOrientation.COLUMN);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't create a test environment", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't create a test environment", e);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't create a test environment", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't create a test environment", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't create a test environment", e);
        }
        log.println("Insert the DataPilotTable");
        if (DPT.hasByName("DataPilotTable")) {
            DPT.removeByName("DataPilotTable");
        }
        DPT.insertNewByName("DataPilotTable", sCellAdress, DPDsc);
        XIndexAccess xIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)DPTS.getDataPilotTables());
        XIndexAccess IA = null;
        try {
            XDataPilotDescriptor xDPT = UnoRuntime.queryInterface(XDataPilotDescriptor.class, xIA.getByIndex(0));
            IA = xDPT.getRowFields();
            System.out.println("COUNT: " + IA.getCount());
            datapilotfield = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)IA.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't get data pilot field", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't get data pilot field", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new StatusException("Couldn't get data pilot field", e);
        }
        try {
            XDataPilotFieldGrouping dpfg = UnoRuntime.queryInterface(XDataPilotFieldGrouping.class, (Object)datapilotfield);
            String[] elements = new String[]{"aName", "otherName"};
            dpfg.createNameGroup(elements);
            DataPilotFieldGroupInfo dpgi = null;
            xIA = UnoRuntime.queryInterface(XIndexAccess.class, (Object)DPTS.getDataPilotTables());
            try {
                XDataPilotDescriptor xDPT = UnoRuntime.queryInterface(XDataPilotDescriptor.class, xIA.getByIndex(0));
                IA = xDPT.getRowFields();
            }
            catch (WrappedTargetException e) {
                e.printStackTrace();
                throw new StatusException("Couldn't get data pilot field", e);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                throw new StatusException("Couldn't get data pilot field", e);
            }
            for (int i = 0; i < IA.getCount(); ++i) {
                datapilotfield = (XInterface)AnyConverter.toObject((Type)new Type(XInterface.class), (Object)IA.getByIndex(i));
                XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, IA.getByIndex(i));
                if (!((Boolean)xPropertySet.getPropertyValue("IsGroupField")).booleanValue()) continue;
                xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)datapilotfield);
                XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, IA.getByIndex(i));
                System.out.println("name: " + xNamed.getName());
                dpgi = (DataPilotFieldGroupInfo)xPropertySet.getPropertyValue("GroupInfo");
            }
            groups = dpgi.Groups;
            XIndexAccess groupAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)groups);
            oObj = UnoRuntime.queryInterface(XInterface.class, groupAccess.getByIndex(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.println("Creating object - " + (oObj == null ? "FAILED" : "OK"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        log.println("Implementationname: " + utils.getImplName(oObj));
        return tEnv;
    }
}

