/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.awt.Rectangle;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.table.XTableChart;
import com.sun.star.table.XTableCharts;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScChartObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a sheetdocument");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XSpreadsheet oSheet = null;
        try {
            log.println("Getting spreadsheet");
            XSpreadsheets oSheets = xSheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
        }
        catch (WrappedTargetException e) {
            log.println("Couldn't get Sheet ");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Couldn't get Sheet ");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        }
        catch (IllegalArgumentException e) {
            log.println("Couldn't get Sheet ");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get sheet", e);
        }
        log.println("Creating the Header");
        ScChartObj.insertIntoCell(1, 0, "JAN", oSheet, "");
        ScChartObj.insertIntoCell(2, 0, "FEB", oSheet, "");
        ScChartObj.insertIntoCell(3, 0, "MAR", oSheet, "");
        ScChartObj.insertIntoCell(4, 0, "APR", oSheet, "");
        ScChartObj.insertIntoCell(5, 0, "MAI", oSheet, "");
        ScChartObj.insertIntoCell(6, 0, "JUN", oSheet, "");
        ScChartObj.insertIntoCell(7, 0, "JUL", oSheet, "");
        ScChartObj.insertIntoCell(8, 0, "AUG", oSheet, "");
        ScChartObj.insertIntoCell(9, 0, "SEP", oSheet, "");
        ScChartObj.insertIntoCell(10, 0, "OCT", oSheet, "");
        ScChartObj.insertIntoCell(11, 0, "NOV", oSheet, "");
        ScChartObj.insertIntoCell(12, 0, "DEC", oSheet, "");
        ScChartObj.insertIntoCell(13, 0, "SUM", oSheet, "");
        log.println("Fill the lines");
        ScChartObj.insertIntoCell(0, 1, "Smith", oSheet, "");
        ScChartObj.insertIntoCell(1, 1, "42", oSheet, "V");
        ScChartObj.insertIntoCell(2, 1, "58.9", oSheet, "V");
        ScChartObj.insertIntoCell(3, 1, "-66.5", oSheet, "V");
        ScChartObj.insertIntoCell(4, 1, "43.4", oSheet, "V");
        ScChartObj.insertIntoCell(5, 1, "44.5", oSheet, "V");
        ScChartObj.insertIntoCell(6, 1, "45.3", oSheet, "V");
        ScChartObj.insertIntoCell(7, 1, "-67.3", oSheet, "V");
        ScChartObj.insertIntoCell(8, 1, "30.5", oSheet, "V");
        ScChartObj.insertIntoCell(9, 1, "23.2", oSheet, "V");
        ScChartObj.insertIntoCell(10, 1, "-97.3", oSheet, "V");
        ScChartObj.insertIntoCell(11, 1, "22.4", oSheet, "V");
        ScChartObj.insertIntoCell(12, 1, "23.5", oSheet, "V");
        ScChartObj.insertIntoCell(13, 1, "=SUM(B2:M2)", oSheet, "");
        ScChartObj.insertIntoCell(0, 2, "Jones", oSheet, "");
        ScChartObj.insertIntoCell(1, 2, "21", oSheet, "V");
        ScChartObj.insertIntoCell(2, 2, "40.9", oSheet, "V");
        ScChartObj.insertIntoCell(3, 2, "-57.5", oSheet, "V");
        ScChartObj.insertIntoCell(4, 2, "-23.4", oSheet, "V");
        ScChartObj.insertIntoCell(5, 2, "34.5", oSheet, "V");
        ScChartObj.insertIntoCell(6, 2, "59.3", oSheet, "V");
        ScChartObj.insertIntoCell(7, 2, "27.3", oSheet, "V");
        ScChartObj.insertIntoCell(8, 2, "-38.5", oSheet, "V");
        ScChartObj.insertIntoCell(9, 2, "43.2", oSheet, "V");
        ScChartObj.insertIntoCell(10, 2, "57.3", oSheet, "V");
        ScChartObj.insertIntoCell(11, 2, "25.4", oSheet, "V");
        ScChartObj.insertIntoCell(12, 2, "28.5", oSheet, "V");
        ScChartObj.insertIntoCell(13, 2, "=SUM(B3:M3)", oSheet, "");
        ScChartObj.insertIntoCell(0, 3, "Brown", oSheet, "");
        ScChartObj.insertIntoCell(1, 3, "31.45", oSheet, "V");
        ScChartObj.insertIntoCell(2, 3, "-20.9", oSheet, "V");
        ScChartObj.insertIntoCell(3, 3, "-117.5", oSheet, "V");
        ScChartObj.insertIntoCell(4, 3, "23.4", oSheet, "V");
        ScChartObj.insertIntoCell(5, 3, "-114.5", oSheet, "V");
        ScChartObj.insertIntoCell(6, 3, "115.3", oSheet, "V");
        ScChartObj.insertIntoCell(7, 3, "-171.3", oSheet, "V");
        ScChartObj.insertIntoCell(8, 3, "89.5", oSheet, "V");
        ScChartObj.insertIntoCell(9, 3, "41.2", oSheet, "V");
        ScChartObj.insertIntoCell(10, 3, "71.3", oSheet, "V");
        ScChartObj.insertIntoCell(11, 3, "25.4", oSheet, "V");
        ScChartObj.insertIntoCell(12, 3, "38.5", oSheet, "V");
        ScChartObj.insertIntoCell(13, 3, "=SUM(A4:L4)", oSheet, "");
        Rectangle oRect = new Rectangle(500, 3000, 25000, 11000);
        XCellRange oRange = UnoRuntime.queryInterface(XCellRange.class, (Object)oSheet);
        XCellRange myRange = oRange.getCellRangeByName("A1:N4");
        XCellRangeAddressable oRangeAddr = UnoRuntime.queryInterface(XCellRangeAddressable.class, (Object)myRange);
        CellRangeAddress myAddr = oRangeAddr.getRangeAddress();
        CellRangeAddress[] oAddr = new CellRangeAddress[]{myAddr};
        XTableChartsSupplier oSupp = UnoRuntime.queryInterface(XTableChartsSupplier.class, (Object)oSheet);
        log.println("Insert Chart");
        XTableCharts oCharts = oSupp.getCharts();
        oCharts.addNewByName("ScChartObj", oRect, oAddr, true, true);
        XTableChart oChart = null;
        try {
            XNameAccess names = (XNameAccess)AnyConverter.toObject((Type)new Type(XNameAccess.class), (Object)UnoRuntime.queryInterface(XNameAccess.class, (Object)oCharts));
            oChart = (XTableChart)AnyConverter.toObject((Type)new Type(XTableChart.class), (Object)names.getByName("ScChartObj"));
        }
        catch (WrappedTargetException e) {
            log.println("Couldn't get TableChart");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }
        catch (NoSuchElementException e) {
            log.println("Couldn't get TableChart");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }
        catch (IllegalArgumentException e) {
            log.println("Couldn't get TableChart");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get TableChart", e);
        }
        log.println("creating a new environment for object");
        TestEnvironment tEnv = new TestEnvironment(oChart);
        tEnv.addObjRelation("setName", new Boolean(true));
        return tEnv;
    }

    public static void insertIntoCell(int CellX, int CellY, String theValue, XSpreadsheet TT1, String flag) {
        XCell oCell = null;
        try {
            oCell = TT1.getCellByPosition(CellX, CellY);
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println("Could not get Cell");
        }
        if (flag.equals("V")) {
            oCell.setValue(new Float(theValue).floatValue());
        } else {
            oCell.setFormula(theValue);
        }
    }
}

