/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScCellTextCursor
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XTextCursor oObj = null;
        XCell aCell = null;
        log.println("Creating a test environment");
        try {
            log.println("Getting spreadsheet");
            XSpreadsheets oSheets = xSheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            XSpreadsheet oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
            log.println("Getting a cell from sheet");
            aCell = oSheet.getCellByPosition(1, 1);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        XText aText = UnoRuntime.queryInterface(XText.class, (Object)aCell);
        aText.setString("ScCellTextCursor");
        oObj = aText.createTextCursor();
        log.println("creating a new environment for ScCellTextCursor object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("XTEXT", aText);
        return tEnv;
    }
}

