/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import ifc.util._XSortable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.ValueComparer;

public class ScCellRangeObj
extends TestCase {
    XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            this.xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XCellRange testRange;
        XCellRange oObj = null;
        log.println("Creating a test environment");
        XSpreadsheets oSpreadsheets = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)this.xSheetDoc).getSheets();
        XNameAccess oNames = UnoRuntime.queryInterface(XNameAccess.class, (Object)oSpreadsheets);
        XSpreadsheet oSheet = null;
        try {
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oNames.getByName(oNames.getElementNames()[0]));
            oObj = oSheet.getCellRangeByPosition(0, 0, 3, 4);
            testRange = UnoRuntime.queryInterface(XCellRange.class, (Object)oObj);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("SHEET", oSheet);
        String[] expectedResults = new String[]{"Sheet1.B1:C1;Sheet1.B3", "Sheet1.B2:B3", "Sheet1.A1 ... Sheet1.B1 ... Sheet1.B5 ... Sheet1.C3 ... Sheet1.D1", "Sheet1.C2", "Sheet1.D4", "Sheet1.A2:A4;Sheet1.C2:D4", "Sheet1.A2"};
        tEnv.addObjRelation("XCellRangesQuery.EXPECTEDRESULTS", expectedResults);
        tEnv.addObjRelation("XCellRangesQuery.CREATEENTRIES", Boolean.TRUE);
        XPropertySet PropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        tEnv.addObjRelation("PropSet", PropSet);
        try {
            tEnv.addObjRelation("XSearchable.MAKEENTRYINCELL", new XCell[]{testRange.getCellByPosition(0, 0), testRange.getCellByPosition(0, 1)});
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            log.println("Cannot make required object relation 'XSearchable.MAKEENTRYINCELL'.");
        }
        final PrintWriter finalLog = log;
        final XCellRange oTable = testRange;
        tEnv.addObjRelation("SORTCHECKER", new _XSortable.XSortChecker(){
            PrintWriter out;
            {
                this.out = finalLog;
            }

            @Override
            public void setPrintWriter(PrintWriter log) {
                this.out = log;
            }

            @Override
            public void prepareToSort() {
                try {
                    oTable.getCellByPosition(0, 0).setValue(4.0);
                    oTable.getCellByPosition(0, 1).setFormula("b");
                    oTable.getCellByPosition(0, 2).setValue(3.0);
                    oTable.getCellByPosition(0, 3).setValue(23.0);
                }
                catch (IndexOutOfBoundsException e) {
                    this.out.println("Exception while checking sort");
                }
            }

            @Override
            public boolean checkSort(boolean isSortNumbering, boolean isSortAscending) {
                this.out.println("Sort checking...");
                boolean res = false;
                String[] value = new String[4];
                for (int i = 0; i < 4; ++i) {
                    try {
                        XCell cell = oTable.getCellByPosition(0, i);
                        value[i] = cell.getFormula();
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.out.println("Exception while checking sort");
                    }
                }
                if (isSortNumbering) {
                    String[] vals;
                    if (isSortAscending) {
                        this.out.println("Sorting ascending");
                        String[] rightVal = new String[]{"3", "4", "23", "b"};
                        vals = new String[]{value[0], value[1], value[2], value[3]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        this.out.println("Expected 3, 4, 23, b");
                        this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                    } else {
                        String[] rightVal = new String[]{"b", "23", "4", "3"};
                        vals = new String[]{value[0], value[1], value[2], value[3]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        this.out.println("Expected b, 23, 4, 3");
                        this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                    }
                } else if (isSortAscending) {
                    String[] rightVal = new String[]{"3", "4", "23", "b"};
                    res = ValueComparer.equalValue(value, rightVal);
                    this.out.println("Expected 3, 4, 23, b");
                    this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                } else {
                    String[] rightVal = new String[]{"b", "23", "4", "3"};
                    res = ValueComparer.equalValue(value, rightVal);
                    this.out.println("Expected b, 23, 4, 3");
                    this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                }
                if (res) {
                    this.out.println("Sorted correctly");
                } else {
                    this.out.println("Sorted uncorrectly");
                }
                return res;
            }
        });
        return tEnv;
    }
}

