/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DefaultDsc;
import util.DesktopTools;
import util.InstCreator;
import util.SOfficeFactory;

public class ScCellObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("Creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XCell oObj = null;
        log.println("Creating a test environment");
        XSpreadsheet oSheet = null;
        XCell cell = null;
        try {
            log.println("Getting spreadsheet");
            XSpreadsheets oSheets = xSheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
            log.println("Getting a cell from sheet");
            oObj = oSheet.getCellByPosition(2, 3);
            cell = UnoRuntime.queryInterface(XCell.class, (Object)oObj);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting cell object from spreadsheet document", e);
        }
        log.println("creating a new environment for ScCellObj object");
        TestEnvironment tEnv = new TestEnvironment(oObj);
        DefaultDsc tDsc = new DefaultDsc("com.sun.star.text.XTextContent", "com.sun.star.text.TextField.URL");
        log.println("    adding InstCreator object");
        tEnv.addObjRelation("XTEXTINFO", new InstCreator(xSheetDoc, tDsc));
        tEnv.addObjRelation("SHEET", oSheet);
        String[] expectedResults = new String[]{"Sheet1.C4", "", "Sheet1.C4", "", "", "Sheet1.C4", "Sheet1.C4"};
        tEnv.addObjRelation("XCellRangesQuery.EXPECTEDRESULTS", expectedResults);
        tEnv.addObjRelation("XCellRangesQuery.CREATEENTRIES", Boolean.TRUE);
        tEnv.addObjRelation("XTextFieldsSupplier.MAKEENTRY", Boolean.TRUE);
        tEnv.addObjRelation("MAKEENTRYINCELL", cell);
        tEnv.addObjRelation("XSearchable.MAKEENTRYINCELL", cell);
        tEnv.addObjRelation("EXCLUDEFINDNEXT", Boolean.TRUE);
        tEnv.addObjRelation("EXPECTEDDEPENDENTVALUES", new int[]{2, 2, 3, 3});
        tEnv.addObjRelation("EXPECTEDPRECEDENTVALUES", new int[]{0, 3, 0, 0});
        tEnv.addObjRelation("RANGEINDICES", new int[]{0, 0});
        tEnv.addObjRelation("SPREADSHEET", xSheetDoc);
        XPropertySet PropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        tEnv.addObjRelation("PropSet", PropSet);
        return tEnv;
    }
}

