/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSheetCellCursor;
import com.sun.star.sheet.XSheetCellRange;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import ifc.util._XSortable;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;
import util.ValueComparer;

public class ScCellCursorObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    protected synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XSheetCellCursor oObj = null;
        TestEnvironment tEnv = null;
        XSpreadsheet oSheet = null;
        XCellRange testRange = null;
        log.println("Creating a test environment");
        XSpreadsheets oSpreadsheets = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc).getSheets();
        try {
            oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oSpreadsheets.getByName(oSpreadsheets.getElementNames()[0]));
            testRange = oSheet.getCellRangeByName("$A$1:$D$4");
            XSheetCellRange testSheetRange = UnoRuntime.queryInterface(XSheetCellRange.class, (Object)testRange);
            oObj = oSheet.createCursorByRange(testSheetRange);
            oSheet.getCellByPosition(1, 1).setValue(1.0);
            oSheet.getCellByPosition(4, 5).setValue(1.0);
            oSheet.getCellByPosition(3, 2).setFormula("xTextDoc");
            oSheet.getCellByPosition(3, 3).setFormula("xTextDoc");
        }
        catch (WrappedTargetException e) {
            log.println("Exception occured while creating test object:");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create test object", e);
        }
        catch (NoSuchElementException e) {
            log.println("Exception occured while creating test object:");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create test object", e);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Exception occured while creating test object:");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create test object", e);
        }
        catch (IllegalArgumentException e) {
            log.println("Exception occured while creating test object:");
            e.printStackTrace(log);
            throw new StatusException("Couldn't create test object", e);
        }
        log.println("Test object successfully created.");
        tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("CRDESC", "Column and RowDescriptions can't be changed for this Object");
        tEnv.addObjRelation("SHEET", oSheet);
        String[] expectedResults = new String[]{"Sheet1.B1", "Sheet1.B2", "Sheet1.A1 ... Sheet1.B1 ... Sheet1.B3 ... Sheet1.C1 ... Sheet1.D1", "", "Sheet1.D4", "Sheet1.A2;Sheet1.C2", "Sheet1.A2"};
        tEnv.addObjRelation("XCellRangesQuery.EXPECTEDRESULTS", expectedResults);
        tEnv.addObjRelation("NewData", new Object[][]{{"", "", "", ""}, {"", "2", "3", "4"}, {"", "2", "3", "4"}, {"", "2", "3", "4"}});
        XPropertySet PropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)oObj);
        tEnv.addObjRelation("PropSet", PropSet);
        final PrintWriter finalLog = log;
        final XCellRange oTable = testRange;
        tEnv.addObjRelation("SORTCHECKER", new _XSortable.XSortChecker(){
            PrintWriter out;
            {
                this.out = finalLog;
            }

            @Override
            public void setPrintWriter(PrintWriter log) {
                this.out = log;
            }

            @Override
            public void prepareToSort() {
                try {
                    oTable.getCellByPosition(0, 0).setValue(4.0);
                    oTable.getCellByPosition(0, 1).setFormula("b");
                    oTable.getCellByPosition(0, 2).setValue(3.0);
                    oTable.getCellByPosition(0, 3).setValue(23.0);
                }
                catch (IndexOutOfBoundsException e) {
                    this.out.println("Exception while checking sort");
                }
            }

            @Override
            public boolean checkSort(boolean isSortNumbering, boolean isSortAscending) {
                this.out.println("Sort checking...");
                boolean res = false;
                String[] value = new String[4];
                for (int i = 0; i < 4; ++i) {
                    try {
                        XCell cell = oTable.getCellByPosition(0, i);
                        value[i] = cell.getFormula();
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.out.println("Exception while checking sort");
                    }
                }
                if (isSortNumbering) {
                    String[] vals;
                    if (isSortAscending) {
                        this.out.println("Sorting ascending");
                        String[] rightVal = new String[]{"3", "4", "23", "b"};
                        vals = new String[]{value[0], value[1], value[2], value[3]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        this.out.println("Expected 3, 4, 23, b");
                        this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                    } else {
                        String[] rightVal = new String[]{"b", "23", "4", "3"};
                        vals = new String[]{value[0], value[1], value[2], value[3]};
                        res = ValueComparer.equalValue(vals, rightVal);
                        this.out.println("Expected b, 23, 4, 3");
                        this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                    }
                } else if (isSortAscending) {
                    String[] rightVal = new String[]{"3", "4", "23", "b"};
                    res = ValueComparer.equalValue(value, rightVal);
                    this.out.println("Expected 3, 4, 23, b");
                    this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                } else {
                    String[] rightVal = new String[]{"b", "23", "4", "3"};
                    res = ValueComparer.equalValue(value, rightVal);
                    this.out.println("Expected b, 23, 4, 3");
                    this.out.println("getting: " + value[0] + ", " + value[1] + ", " + value[2] + ", " + value[3]);
                }
                if (res) {
                    this.out.println("Sorted correctly");
                } else {
                    this.out.println("Sorted uncorrectly");
                }
                return res;
            }
        });
        return tEnv;
    }
}

