/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSheetAnnotation;
import com.sun.star.sheet.XSheetAnnotationAnchor;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XTextCursor;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScAnnotationTextCursor
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XTextCursor oObj = null;
        log.println("Creating a test environment");
        CellAddress cellPos = new CellAddress(0, 1, 2);
        try {
            log.println("Getting test object ");
            XSpreadsheetDocument xArea = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc);
            XSpreadsheets oSheets = xArea.getSheets();
            XIndexAccess XAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            XSpreadsheet oSheet = (XSpreadsheet)XAccess.getByIndex(cellPos.Sheet);
            XCellRange oCRange = UnoRuntime.queryInterface(XCellRange.class, (Object)oSheet);
            XCell oCell = oCRange.getCellByPosition(cellPos.Column, cellPos.Row);
            XSheetAnnotationAnchor oAnnoA = UnoRuntime.queryInterface(XSheetAnnotationAnchor.class, (Object)oCell);
            XSheetAnnotation oAnno = oAnnoA.getAnnotation();
            XSimpleText aText = UnoRuntime.queryInterface(XSimpleText.class, (Object)oAnno);
            aText.setString("A nice little Test");
            oObj = aText.createTextCursor();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }
}

