/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSheetAnnotation;
import com.sun.star.sheet.XSheetAnnotationAnchor;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.SOfficeFactory;

public class ScAnnotationObj
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XSheetAnnotation oAnno;
        XSheetAnnotation oObj = null;
        log.println("Creating a test environment");
        CellAddress cellPos = new CellAddress(0, 1, 2);
        log.println("Getting test object ");
        XSpreadsheetDocument xArea = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc);
        XSpreadsheets oSheets = xArea.getSheets();
        XIndexAccess XAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
        XCell oCell = null;
        try {
            XSpreadsheet oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)XAccess.getByIndex(cellPos.Sheet));
            XCellRange oCRange = UnoRuntime.queryInterface(XCellRange.class, (Object)oSheet);
            oCell = oCRange.getCellByPosition(cellPos.Column, cellPos.Row);
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Error getting test object from spreadsheet document", e);
        }
        XSheetAnnotationAnchor oAnnoA = UnoRuntime.queryInterface(XSheetAnnotationAnchor.class, (Object)oCell);
        oObj = oAnno = oAnnoA.getAnnotation();
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("CELLPOS", cellPos);
        return tEnv;
    }
}

