/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleSpreadsheet
extends TestCase {
    static XSpreadsheetDocument xSheetDoc = null;

    @Override
    protected void initialize(TestParameters tParam, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)tParam.getMSF());
        try {
            log.println("creating a Spreadsheet document");
            xSheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document", e);
        }
    }

    @Override
    protected void cleanup(TestParameters tParam, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSheetDoc);
        DesktopTools.closeDoc(oComp);
    }

    @Override
    public synchronized TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) throws StatusException {
        XAccessibleContext oObj = null;
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)xSheetDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), xModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)58);
        oObj = AccessibilityTools.SearchedContext;
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XCell xCell = null;
        String text = "Text for testing of the interface XAccessibleText";
        try {
            XSpreadsheets oSheets = xSheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            XSpreadsheet oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
            xCell = oSheet.getCellByPosition(5, 5);
            xCell.setFormula("Text for testing of the interface XAccessibleText");
        }
        catch (WrappedTargetException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        final XCell fCell = xCell;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                fCell.setFormula("firing event");
                fCell.setFormula("Text for testing of the interface XAccessibleText");
            }
        });
        return tEnv;
    }
}

