/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.awt.XWindow;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.URL;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessiblePageHeaderArea
extends TestCase {
    static XSpreadsheetDocument xSpreadsheetDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessible oObj = null;
        XCell xCell = null;
        try {
            XSpreadsheets oSheets = xSpreadsheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            XSpreadsheet oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
            xCell = oSheet.getCellByPosition(0, 0);
            xCell.setFormula("ScAccessiblePageHeaderArea");
        }
        catch (WrappedTargetException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XController xController = aModel.getCurrentController();
        try {
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = ".uno:PrintPreview";
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            if (xDispatcher != null) {
                xDispatcher.dispatch(aURL, null);
            }
        }
        catch (Exception e) {
            log.println("Couldn't change mode");
            throw new StatusException(Status.failed("Couldn't change mode"));
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentContainerWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        try {
            oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)25, "").getAccessibleChild(0);
            XAccessibleContext cont = UnoRuntime.queryInterface(XAccessibleContext.class, (Object)oObj);
            XAccessibleStateSet StateSet = cont.getAccessibleStateSet();
            if (StateSet.contains((short)27)) {
                log.println("Object is transient");
            }
        }
        catch (IndexOutOfBoundsException iabe) {
            throw new StatusException("Couldn't find needed Child", iabe);
        }
        log.println("ImplementationName " + utils.getImplName(oObj));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XAccessibleContext zoomIn = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Zoom In");
        final XAccessibleAction pressZoom = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)zoomIn);
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                try {
                    pressZoom.doAccessibleAction(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        try {
            XCloseable oComp = UnoRuntime.queryInterface(XCloseable.class, (Object)xSpreadsheetDoc);
            oComp.close(true);
        }
        catch (CloseVetoException e) {
            log.println("Couldn't close document: " + e.getMessage());
        }
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }
}

