/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XHeaderFooterContent;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.style.XStyle;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.URL;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.Status;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessiblePageHeader
extends TestCase {
    static XSpreadsheetDocument xSpreadsheetDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        XCell xCell = null;
        try {
            XSpreadsheets oSheets = xSpreadsheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            XSpreadsheet oSheet = null;
            try {
                oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
            }
            catch (IllegalArgumentException iae) {
                throw new StatusException("couldn't get sheet", iae);
            }
            xCell = oSheet.getCellByPosition(0, 0);
            xCell.setFormula("ScAccessiblePageHeader");
        }
        catch (WrappedTargetException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XController xController = aModel.getCurrentController();
        try {
            XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.util.URLTransformer"));
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = ".uno:PrintPreview";
            xParser.parseStrict(aParseURL);
            URL aURL = aParseURL[0];
            XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
            if (xDispatcher != null) {
                xDispatcher.dispatch(aURL, null);
            }
        }
        catch (Exception e) {
            log.println("Couldn't change mode");
            throw new StatusException(Status.failed("Couldn't change mode"));
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)25, "");
        log.println("ImplementationName " + utils.getImplName(oObj));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XStyleFamiliesSupplier StyleFam = UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)xSpreadsheetDoc);
        XNameAccess StyleFamNames = StyleFam.getStyleFamilies();
        XStyle StdStyle = null;
        try {
            XNameAccess PageStyles = (XNameAccess)AnyConverter.toObject((Type)new Type(XNameAccess.class), (Object)StyleFamNames.getByName("PageStyles"));
            StdStyle = (XStyle)AnyConverter.toObject((Type)new Type(XStyle.class), (Object)PageStyles.getByName("Default"));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by name", e);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get by name", e);
        }
        catch (IllegalArgumentException iae) {
            throw new StatusException("Couldn't convert any", iae);
        }
        final XPropertySet PropSet = UnoRuntime.queryInterface(XPropertySet.class, (Object)StdStyle);
        XHeaderFooterContent RPHC = null;
        log.println("creating a test environment");
        try {
            RPHC = (XHeaderFooterContent)AnyConverter.toObject((Type)new Type(XHeaderFooterContent.class), (Object)PropSet.getPropertyValue("RightPageHeaderContent"));
        }
        catch (WrappedTargetException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get HeaderContent", e);
        }
        catch (UnknownPropertyException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get HeaderContent", e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't get HeaderContent", e);
        }
        final XHeaderFooterContent RPHC2 = RPHC;
        final XText center = RPHC2.getCenterText();
        final XText left = RPHC2.getLeftText();
        final XText right = RPHC2.getRightText();
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                center.setString("CENTER");
                left.setString("LEFT");
                right.setString("RIGHT");
                try {
                    PropSet.setPropertyValue("RightPageHeaderContent", RPHC2);
                }
                catch (UnknownPropertyException e) {
                }
                catch (PropertyVetoException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (WrappedTargetException wrappedTargetException) {
                    // empty catch block
                }
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        try {
            XCloseable oComp = UnoRuntime.queryInterface(XCloseable.class, (Object)xSpreadsheetDoc);
            oComp.close(true);
        }
        catch (CloseVetoException e) {
            log.println("Couldn't close document: " + e.getMessage());
        }
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }
}

