/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleDocument
extends TestCase {
    static XComponent xSpreadsheetDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        log.println("getting Drawpages");
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        AccessibilityTools at = new AccessibilityTools();
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)13, "");
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        final XWindow xDocWin = xWindow;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                Rectangle rect = xDocWin.getPosSize();
                xDocWin.setPosSize(rect.X, rect.Y, rect.Height, rect.Width - 10, (short)15);
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        DesktopTools.closeDoc(xSpreadsheetDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            String url = utils.getFullTestURL("calcshapes.sxc");
            log.println("loading document " + url);
            xSpreadsheetDoc = SOF.loadDocument(url);
            this.shortWait();
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
    }

    private void shortWait() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }
}

