/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleCsvRuler
extends TestCase {
    Thread lThread = null;
    static XAccessibleAction accAction = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        this.shortWait();
        XMultiServiceFactory msf = (XMultiServiceFactory)Param.getMSF();
        try {
            oObj = (XInterface)msf.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Cancel");
        accAction = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oObj);
        XAccessibleContext acc = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)46);
        log.println("Click on: " + acc.getAccessibleName());
        XAccessibleAction accAction2 = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)acc);
        try {
            accAction2.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException iae) {
            // empty catch block
        }
        AccessibilityTools.printAccessibleTree(log, xRoot);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)60, "Ruler", true);
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        tEnv.addObjRelation("EditOnly", "This method isn't supported in this dialog");
        XAccessibleText text = UnoRuntime.queryInterface(XAccessibleText.class, (Object)oObj);
        int lastone = 100;
        for (int i = 0; i < 1000; ++i) {
            try {
                text.getCharacterBounds(i);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                lastone = i - 1;
                break;
            }
        }
        tEnv.addObjRelation("LimitedBounds", new Integer(lastone));
        tEnv.addObjRelation("PreviousUsed", new int[]{11, 22, 33, 44, 55, 66, 77, 88, 99});
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        log.println("opening dialog");
        PropertyValue[] args = new PropertyValue[1];
        try {
            args[0] = new PropertyValue();
            args[0].Name = "InteractionHandler";
            args[0].Value = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.comp.uui.UUIInteractionHandler");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lThread = new loadThread(SOF, args);
        this.lThread.start();
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    public class loadThread
    extends Thread {
        private SOfficeFactory SOF = null;
        private PropertyValue[] args = null;
        public XComponent xSpreadSheedDoc = null;

        public loadThread(SOfficeFactory SOF, PropertyValue[] Args) {
            this.SOF = SOF;
            this.args = Args;
        }

        @Override
        public void run() {
            try {
                String url = utils.getFullTestURL("10test.csv");
                ScAccessibleCsvRuler.this.log.println("loading " + url);
                this.SOF.loadDocument(url, this.args);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new StatusException("Couldn't create document ", e);
            }
        }
    }
}

