/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleCsvGrid
extends TestCase {
    Thread lThread = null;
    static XAccessibleAction accAction = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XInterface oObj = null;
        this.shortWait();
        try {
            oObj = (XInterface)((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)oObj);
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)tk.getActiveTopWindow());
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Cancel");
        accAction = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oObj);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)58, true);
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    closing Dialog ");
        try {
            accAction.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException iae) {
            log.println("Couldn't close dialog");
        }
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        log.println("opening dialog");
        PropertyValue[] args = new PropertyValue[1];
        try {
            args[0] = new PropertyValue();
            args[0].Name = "InteractionHandler";
            args[0].Value = ((XMultiServiceFactory)Param.getMSF()).createInstance("com.sun.star.comp.uui.UUIInteractionHandler");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.lThread = new loadThread(SOF, args);
        this.lThread.start();
        this.shortWait();
    }

    private void shortWait() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            this.log.println("While waiting :" + e);
        }
    }

    public class loadThread
    extends Thread {
        private SOfficeFactory SOF = null;
        private PropertyValue[] args = null;
        public XComponent xSpreadSheedDoc = null;

        public loadThread(SOfficeFactory SOF, PropertyValue[] Args) {
            this.SOF = SOF;
            this.args = Args;
        }

        @Override
        public void run() {
            try {
                String url = utils.getFullTestURL("10test.csv");
                ScAccessibleCsvGrid.this.log.println("loading " + url);
                this.SOF.loadDocument(url, this.args);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new StatusException("Couldn't create document ", e);
            }
        }
    }
}

