/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.table.XColumnRowRange;
import com.sun.star.table.XTableColumns;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class ScAccessibleCell
extends TestCase {
    static XSpreadsheetDocument xSpreadsheetDoc = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        SOfficeFactory SOF = SOfficeFactory.getFactory((XMultiServiceFactory)Param.getMSF());
        try {
            log.println("creating a spreadsheetdocument");
            xSpreadsheetDoc = SOF.createCalcDoc(null);
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Couldn't create document ", e);
        }
        XAccessibleContext oObj = null;
        XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDoc);
        XWindow xWindow = AccessibilityTools.getCurrentWindow((XMultiServiceFactory)Param.getMSF(), aModel);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)59, "B1");
        log.println("ImplementationName " + utils.getImplName(oObj));
        TestEnvironment tEnv = new TestEnvironment(oObj);
        XCell xCell = null;
        String text = "XAccessibleText";
        try {
            XSpreadsheets oSheets = xSpreadsheetDoc.getSheets();
            XIndexAccess oIndexSheets = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oSheets);
            XSpreadsheet oSheet = null;
            try {
                oSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)oIndexSheets.getByIndex(0));
            }
            catch (IllegalArgumentException iae) {
                throw new StatusException("couldn't get sheet", iae);
            }
            xCell = oSheet.getCellByPosition(1, 0);
            xCell.setFormula("XAccessibleText");
            XColumnRowRange oColumnRowRange = UnoRuntime.queryInterface(XColumnRowRange.class, (Object)oSheet);
            XTableColumns oColumns = oColumnRowRange.getColumns();
            XIndexAccess oIndexAccess = UnoRuntime.queryInterface(XIndexAccess.class, (Object)oColumns);
            XPropertySet column = UnoRuntime.queryInterface(XPropertySet.class, oIndexAccess.getByIndex(1));
            column.setPropertyValue("OptimalWidth", new Boolean(true));
        }
        catch (WrappedTargetException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (IndexOutOfBoundsException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (UnknownPropertyException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (PropertyVetoException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        catch (IllegalArgumentException e) {
            log.println("Exception ceating relation :");
            e.printStackTrace(log);
        }
        tEnv.addObjRelation("EditOnly", "This method is only supported if the Cell is in edit mode");
        final XCell fCell = xCell;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                fCell.setFormula("firing event");
                fCell.setFormula("XAccessibleText");
            }
        });
        tEnv.addObjRelation("XAccessibleText.Text", "XAccessibleText");
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xSheetDoc ");
        XComponent oComp = UnoRuntime.queryInterface(XComponent.class, (Object)xSpreadsheetDoc);
        DesktopTools.closeDoc(oComp);
    }
}

