/*
 * Decompiled with CFR 0.152.
 */
package mod._sc;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import ifc.accessibility._XAccessibleEventBroadcaster;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.AccessibilityTools;
import util.DesktopTools;
import util.SOfficeFactory;
import util.utils;

public class AccessibleEditableTextPara_HeaderFooter
extends TestCase {
    protected static XComponent xCalcDoc = null;
    protected static XMultiServiceFactory msf = null;
    protected static XAccessibleAction action = null;

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters Param, PrintWriter log) {
        XAccessibleContext oObj = null;
        Object toolkit = null;
        try {
            toolkit = msf.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (Exception e) {
            log.println("Couldn't get toolkit");
            e.printStackTrace(log);
            throw new StatusException("Couldn't get toolkit", e);
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, toolkit);
        utils.shortWait(Param.getInt("ShortWait"));
        DiagThread psDiag = new DiagThread(xCalcDoc, msf);
        psDiag.start();
        utils.shortWait(Param.getInt("ShortWait") * 5);
        XTopWindow atw = tk.getActiveTopWindow();
        XWindow xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)atw);
        XAccessible xRoot = AccessibilityTools.getAccessibleObject(xWindow);
        utils.shortWait(Param.getInt("ShortWait"));
        AccessibilityTools.printAccessibleTree(log, xRoot, Param.getBool("DebugIsActive"));
        XAccessibleContext ok_button = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)44, "Cancel");
        oObj = AccessibilityTools.getAccessibleObjectForRole(xRoot, (short)41);
        log.println("ImplementationName " + utils.getImplName(oObj));
        log.println("AccessibleName " + oObj.getAccessibleName());
        log.println("ParentDescription " + oObj.getAccessibleParent().getAccessibleContext().getAccessibleDescription());
        TestEnvironment tEnv = new TestEnvironment(oObj);
        action = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)ok_button);
        XAccessibleText text = UnoRuntime.queryInterface(XAccessibleText.class, (Object)oObj);
        XAccessibleEditableText eText = UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)oObj);
        eText.setText("LEFT");
        tEnv.addObjRelation("XAccessibleText.Text", text.getText());
        tEnv.addObjRelation("Destroy", "AccessibleEditableTextPara_PreviewCell");
        final XAccessibleEditableText editText = eText;
        tEnv.addObjRelation("EventProducer", new _XAccessibleEventBroadcaster.EventProducer(){

            @Override
            public void fireEvent() {
                editText.setText("LEFT_EVENT");
            }
        });
        return tEnv;
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    disposing xCalcDoc ");
        try {
            action.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException ioe) {
            log.println("Couldn't close dialog");
        }
        catch (DisposedException de) {
            log.println("Dialog already disposed");
        }
        DesktopTools.closeDoc(xCalcDoc);
    }

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        msf = (XMultiServiceFactory)Param.getMSF();
        try {
            SOfficeFactory SOF = SOfficeFactory.getFactory(msf);
            xCalcDoc = UnoRuntime.queryInterface(XComponent.class, (Object)SOF.createCalcDoc(null));
        }
        catch (Exception e) {
            throw new StatusException("Can't create document", e);
        }
    }

    public class DiagThread
    extends Thread {
        public XComponent xCalcDoc = null;
        public XMultiServiceFactory msf = null;

        public DiagThread(XComponent xCalcDoc, XMultiServiceFactory msf) {
            this.xCalcDoc = xCalcDoc;
            this.msf = msf;
        }

        @Override
        public void run() {
            XModel aModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xCalcDoc);
            XController xController = aModel.getCurrentController();
            try {
                String aSlotID = ".uno:EditHeaderAndFooter";
                XDispatchProvider xDispProv = UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
                XURLTransformer xParser = UnoRuntime.queryInterface(XURLTransformer.class, this.msf.createInstance("com.sun.star.util.URLTransformer"));
                URL[] aParseURL = new URL[]{new URL()};
                aParseURL[0].Complete = aSlotID;
                xParser.parseStrict(aParseURL);
                URL aURL = aParseURL[0];
                XDispatch xDispatcher = xDispProv.queryDispatch(aURL, "", 0);
                if (xDispatcher != null) {
                    xDispatcher.dispatch(aURL, null);
                }
            }
            catch (Exception e) {
                AccessibleEditableTextPara_HeaderFooter.this.log.println("Couldn't open dialog");
            }
        }
    }
}

