/*
 * Decompiled with CFR 0.152.
 */
package mod._remotebridge;

import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;

public class various
extends TestCase {
    protected String connectString = null;
    protected static final int basePort = 50000;
    private int curPort = 50000;
    private XAcceptor xAcctr;
    private XConnector xCntr;
    private XBridgeFactory xBrdgFctr;
    private AcceptorThread accThread;
    public XInterface bridge = null;
    private final boolean[] bridgeDisposed = new boolean[1];

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            XInterface xInt = (XInterface)xMSF.createInstance("com.sun.star.bridge.Bridge");
            TestEnvironment tEnv = new TestEnvironment(xInt);
            String cncstr = (String)tParam.get("CNCSTR");
            int idx = cncstr.indexOf("host=") + 5;
            log.println("Choose Port nr: " + this.curPort);
            this.connectString = "socket,host=" + cncstr.substring(idx, cncstr.indexOf(",", idx)) + ",port=" + this.curPort;
            XInterface oAcctr = (XInterface)xMSF.createInstance("com.sun.star.connection.Acceptor");
            this.xAcctr = UnoRuntime.queryInterface(XAcceptor.class, (Object)oAcctr);
            XInterface oCntr = (XInterface)xMSF.createInstance("com.sun.star.connection.Connector");
            this.xCntr = UnoRuntime.queryInterface(XConnector.class, (Object)oCntr);
            XInterface oBrdg = (XInterface)xMSF.createInstance("com.sun.star.bridge.BridgeFactory");
            this.xBrdgFctr = UnoRuntime.queryInterface(XBridgeFactory.class, (Object)oBrdg);
            MyInstanceProvider xInstProv = new MyInstanceProvider(xMSF);
            this.accThread = new AcceptorThread(this.xAcctr, xInstProv, this.xBrdgFctr);
            this.accThread.start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            XConnection xConnection = this.xCntr.connect(this.connectString);
            String protocol = "urp";
            String bridgeName = protocol + ":" + this.connectString;
            tEnv.addObjRelation("XInitialization.args", new Object[]{bridgeName, protocol, xConnection, null});
            this.bridge = tEnv.getTestObject();
            return tEnv;
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        XComponent xComp;
        System.out.println("++++++++ cleanup");
        this.xAcctr.stopAccepting();
        if (this.accThread.isAlive()) {
            this.accThread.interrupt();
        }
        if ((xComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.xAcctr)) != null) {
            xComp.dispose();
        }
        if ((xComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.xCntr)) != null) {
            xComp.dispose();
        }
        if ((xComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.xBrdgFctr)) != null) {
            xComp.dispose();
        }
        if ((xComp = UnoRuntime.queryInterface(XComponent.class, (Object)this.bridge)) != null) {
            System.out.println("######## Dispose bridge");
            this.bridgeDisposed[0] = true;
            xComp.dispose();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    protected class AcceptorThread
    extends Thread {
        public Exception ex = null;
        private XAcceptor acc = null;
        private XInstanceProvider xInstProv = null;
        private XBridgeFactory xBrdgFctr = null;
        public XConnection acceptedCall = null;

        public AcceptorThread(XAcceptor acc, XInstanceProvider xInstProv, XBridgeFactory xBrdgFctr) {
            this.acc = acc;
            this.xInstProv = xInstProv;
            this.xBrdgFctr = xBrdgFctr;
        }

        @Override
        public void run() {
            try {
                this.acceptedCall = this.acc.accept(various.this.connectString);
            }
            catch (IllegalArgumentException e) {
                this.ex = e;
            }
            catch (ConnectionSetupException e) {
                this.ex = e;
            }
            catch (AlreadyAcceptingException e) {
                this.ex = e;
            }
        }
    }

    protected class MyInstanceProvider
    implements XInstanceProvider {
        private XMultiServiceFactory xMSF = null;

        public MyInstanceProvider(XMultiServiceFactory xMSF) {
            this.xMSF = xMSF;
        }

        @Override
        public Object getInstance(String aInstanceName) throws NoSuchElementException {
            System.out.println("######## Try to get " + aInstanceName);
            try {
                return this.xMSF.createInstance(aInstanceName);
            }
            catch (Exception e) {
                throw new StatusException("Unexpected exception", e);
            }
        }
    }
}

