/*
 * Decompiled with CFR 0.152.
 */
package mod._pcr;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XFrame;
import com.sun.star.inspection.XObjectInspectorModel;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import helper.PropertyHandlerFactroy;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.utils;

public class ObjectInspectorModel
extends TestCase {
    protected static Object StarDesktop = null;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("create a desktop...");
        StarDesktop = DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF());
        if (StarDesktop == null) {
            throw new StatusException("Could not get a Desktop: null", null);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        this.cleanup(tParam, log);
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        XPropertySet xMSFProp = UnoRuntime.queryInterface(XPropertySet.class, (Object)xMSF);
        XComponentContext xDefaultContext = null;
        try {
            Object oDefaultContext = xMSFProp.getPropertyValue("DefaultContext");
            xDefaultContext = UnoRuntime.queryInterface(XComponentContext.class, oDefaultContext);
        }
        catch (UnknownPropertyException e) {
            throw new StatusException("could not get DefaultContext from xMSF", e);
        }
        catch (WrappedTargetException e) {
            throw new StatusException("could not get DefaultContext from xMSF", e);
        }
        catch (Exception e) {
            throw new StatusException("could not get DefaultContext from xMSF", e);
        }
        try {
            Object[] oHandlerFactories = new Object[]{new PropertyHandlerFactroy()};
            int minHelpTextLines = 200;
            int maxHelpTextLines = 400;
            XObjectInspectorModel oInspectorModel = com.sun.star.inspection.ObjectInspectorModel.createWithHandlerFactoriesAndHelpSection(xDefaultContext, oHandlerFactories, minHelpTextLines, maxHelpTextLines);
            log.println("ImplementationName '" + utils.getImplName(oInspectorModel) + "'");
            TestEnvironment tEnv = new TestEnvironment(oInspectorModel);
            tEnv.addObjRelation("minHelpTextLines", new Integer(minHelpTextLines));
            tEnv.addObjRelation("maxHelpTextLines", new Integer(maxHelpTextLines));
            return tEnv;
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    Closing dialog if one exists ... ");
        XFrame existentInspector = null;
        XFrame xFrame = UnoRuntime.queryInterface(XFrame.class, StarDesktop);
        existentInspector = xFrame.findFrame("ObjectInspector", 255);
        if (existentInspector != null) {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)existentInspector);
            try {
                closer.close(true);
            }
            catch (CloseVetoException e) {
                log.println("Could not close inspector: " + e.toString());
            }
        }
    }
}

