/*
 * Decompiled with CFR 0.152.
 */
package mod._pcr;

import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.inspection.XObjectInspector;
import com.sun.star.inspection.XObjectInspectorModel;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import helper.PropertyHandlerImpl;
import java.io.PrintWriter;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import util.DesktopTools;
import util.utils;

public class ObjectInspector
extends TestCase {
    protected static Object StarDesktop = null;

    @Override
    protected void initialize(TestParameters Param, PrintWriter log) {
        log.println("create a desktop...");
        StarDesktop = DesktopTools.createDesktop((XMultiServiceFactory)Param.getMSF());
        if (StarDesktop == null) {
            throw new StatusException("Could not get a Desktop: null", null);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        this.cleanup(tParam, log);
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        try {
            XInterface oInspector = (XInterface)xMSF.createInstance("com.sun.star.inspection.ObjectInspector");
            XObjectInspector xInspector = UnoRuntime.queryInterface(XObjectInspector.class, (Object)oInspector);
            log.println("ImplementationName '" + utils.getImplName(xInspector) + "'");
            XInterface oInspectorModel = (XInterface)xMSF.createInstance("com.sun.star.inspection.ObjectInspectorModel");
            XObjectInspectorModel xInspectorModel = UnoRuntime.queryInterface(XObjectInspectorModel.class, (Object)oInspectorModel);
            XInterface oInspectorModelToSet = (XInterface)xMSF.createInstance("com.sun.star.inspection.ObjectInspectorModel");
            XObjectInspectorModel xInspectorModelToSet = UnoRuntime.queryInterface(XObjectInspectorModel.class, (Object)oInspectorModelToSet);
            log.println("create a floating frame...");
            XWindow xWindow = null;
            try {
                XWindowPeer xWindowPeer = DesktopTools.createFloatingWindow(xMSF);
                xWindow = UnoRuntime.queryInterface(XWindow.class, (Object)xWindowPeer);
            }
            catch (StatusException e) {
                throw new StatusException("Coud not create test object", e);
            }
            XInterface oFrame = (XInterface)xMSF.createInstance("com.sun.star.frame.Frame");
            XFrame xFrame = UnoRuntime.queryInterface(XFrame.class, (Object)oFrame);
            xFrame.setName("ObjectInspector");
            xFrame.initialize(xWindow);
            XFramesSupplier xFramesSup = UnoRuntime.queryInterface(XFramesSupplier.class, StarDesktop);
            XFrames xFrames = xFramesSup.getFrames();
            xFrames.append(xFrame);
            log.println("attach ObjectInspector to floating frame...");
            XInitialization xOII = UnoRuntime.queryInterface(XInitialization.class, (Object)xInspectorModel);
            xOII.initialize(new Object[0]);
            xInspector.setInspectorModel(xInspectorModel);
            Object[] oInspect = new Object[]{new PropertyHandlerImpl()};
            TestEnvironment tEnv = new TestEnvironment(xInspector);
            tEnv.addObjRelation("Frame", xFrame);
            tEnv.addObjRelation("XObjectInspector.toInspect", oInspect);
            tEnv.addObjRelation("XObjectInspector.InspectorModelToSet", xInspectorModelToSet);
            return tEnv;
        }
        catch (Exception e) {
            e.printStackTrace(log);
            throw new StatusException("Unexpected exception", e);
        }
    }

    @Override
    protected void cleanup(TestParameters Param, PrintWriter log) {
        log.println("    Closing dialog if one exists ... ");
        XFrame existentInspector = null;
        XFrame xFrame = UnoRuntime.queryInterface(XFrame.class, StarDesktop);
        existentInspector = xFrame.findFrame("ObjectInspector", 255);
        if (existentInspector != null) {
            XCloseable closer = UnoRuntime.queryInterface(XCloseable.class, (Object)existentInspector);
            try {
                closer.close(true);
            }
            catch (CloseVetoException e) {
                log.println("Could not close inspector: " + e.toString());
            }
        }
    }
}

